package com.ejianc.business.profinance.projectloan.service;

import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.projectloan.bean.ProjectLoanEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 借款管理-项目借款实体
 *
 * @author baipengyan
 */
public interface IProjectLoanService extends IBaseService<ProjectLoanEntity> {

	/**
	 * 金额合计
	 *
	 * @param param 查询参数
	 *
	 * @return 金额合计
	 */
	Map<String, BigDecimal> fetchTotalMny(QueryParam param);
	/**
	 * 根据id更新状态
	 *
	 * @param column     列名
	 */
	void updateColumnValue(List<Long> ids, String column, String value);
}
