package com.ejianc.business.profinance.utils;
import com.alibaba.fastjson.JSON;
import okhttp3.*;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 广联达接口对接
 */
public class GlodonSalaryApiClient {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String APP_ID_PARAM_NAME="appid";
    private static final String TIMESTAMP_PARAM_NAME="ts";
    private static final String SIGN_PARAM_NAME="sign";

    private static final String OPEN_ALI_HOST = "https://glm-test.glodon.com/api/open";
    private static final String PRODUCT_OPEN_ALI_HOST = "https://glm.glodon.com/api/open";
    private static final String DISPATCH_HOST = "https://glm-test.glodon.com/iot";

    private static final String PRODUCT_APPID = "9b4a75e81fc0437ebb74752096153cc7";
    private static final String PRODUCT_SECRET = "ddb091eb6632665cc8adc3012f35cdb1";

    private static final String ALL_WORKER_BASE_INFO = "/worker/allWorkerBaseInfo";

    //工人工资单据
    private static final String SALARY = "/salaryV2/pageV2";
    //工人工资详情
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";
    //广联达项目
    private static final String PROJECT_LIST = "/admin/project/listByOrgId";

    private String host = PRODUCT_OPEN_ALI_HOST;
    private String appId = PRODUCT_APPID;
    private String appSecret = PRODUCT_SECRET;

    public static void main(String[] args) {
        //查1
//        OpenApiTestClient openApiTestClient = new OpenApiTestClient();
//        Map<String, Object> params = new HashMap<>();
//        params.put("projectId", "");
//        params.put("start", "2019-08-15 00:00:00");
//        params.put("end", "2019-08-16 00:00:00");
//        params.put("pageNum", "1");
//        params.put("pageSize", "50");
//        openApiTestClient.sendGETRequest(ALL_WORKER_BASE_INFO, params);

        //查2
//        String projectId = null; String year = ""; String month = "";
////        projectId = StringUtils.isBlank(projectId) ? "523215775027712" : projectId;
//        projectId = StringUtils.isBlank(projectId) ? "555602700182528" : projectId;
//        year = StringUtils.isBlank(year) ? "2022" : year;
//        month = StringUtils.isBlank(month) ? "3" : month;
//        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
//        Map<String, Object> params = new HashMap<>();
//        params.put("projectId", projectId);
//        params.put("year", year);
//        params.put("month", month);
//        params.put("pageNum", "1");
//        params.put("pageSize", "1000");
//        String salaryResult = openApiTestClient.sendGETRequest(WORKER_DETAIL, params);


        //查3
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", "1438833");
        params.put("orgId", "1441301");
        String salaryResult = openApiTestClient.sendGETRequest(PROJECT_LIST, params);



        System.out.println(salaryResult);

    }


    public String sendGETRequest(String path, Map<String,Object> requestParams){
        String host = this.host;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(host + path)).newBuilder();
        requestParams.put(APP_ID_PARAM_NAME,appId);
        String sign = getSign(requestParams);
        requestParams.put(SIGN_PARAM_NAME,sign);
        requestParams.forEach((s, o) -> {
            urlBuilder.addQueryParameter(s, (String) o);
        });
        logger.info("开始请求接入服务系统接口，地址为：{}",urlBuilder.build());
        Request request = new Request.Builder()
                .url(urlBuilder.build())
                .build();
        return getResult(request);
    }

    private String getSign(Map<String,Object> paramsMap){
        List<String> paramsList = new ArrayList<>();
        paramsMap.forEach((s, o) -> {
            String stringBuilder = s + o;
            paramsList.add(stringBuilder);
        });
        StringBuilder beforeMd5 = new StringBuilder();
        beforeMd5.append(appSecret);
        paramsList.stream()
                .sorted(String::compareTo)
                .collect(Collectors.toList())
                .forEach(beforeMd5::append);
        beforeMd5.append(appSecret);
        return DigestUtils.md5Hex(beforeMd5.toString()).toUpperCase();
    }

    public String sendPOSTRequest(String path, Object bodyParam){
        String host = this.host;
        String jsonString = JSON.toJSONString(bodyParam);
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json;charset=UTF-8"),jsonString);
        StringBuilder signBuilder = new StringBuilder();
        String time = System.currentTimeMillis() + "";
        signBuilder.append(appSecret)
                .append(APP_ID_PARAM_NAME)
                .append(appId)
                .append(TIMESTAMP_PARAM_NAME)
                .append(time)
                .append(appSecret);
        logger.info("开始请求开放平台服务系统接口，地址为：{}",host+path);
        Request request = new Request.Builder()
                .addHeader(APP_ID_PARAM_NAME,appId)
                .addHeader(TIMESTAMP_PARAM_NAME,time)
                .addHeader(SIGN_PARAM_NAME, DigestUtils.md5Hex(signBuilder.toString()).toUpperCase())
                .url(host+path)
                .post(requestBody)
                .build();
        return getResult(request);
    }

    private String getResult(Request request) {
        OkHttpClient client = new OkHttpClient();
        Response response;
        try {
            response = client.newCall(request).execute();
            if (response.body() != null) {
                return response.body().string();
            } else {
                throw new RuntimeException();
            }
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}