package com.ejianc.business.profinance.person.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 借款管理-个人还款明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_person_repay_detail")
public class PersonRepayDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_loan_id")
    private Long sourceLoanId; // 借款单号id
    @TableField(value="source_loan_code")
    private String sourceLoanCode; // 借款单编码
    @TableField(value="source_loan_name")
    private String sourceLoanName; // 借款单名称
    @TableField(value="source_loan_date")
    private Date sourceLoanDate; // 借款日期
    @TableField(value="source_expect_repay_date")
    private Date sourceExpectRepayDate; // 预计还款日期
    @TableField(value="source_loan_mny")
    private BigDecimal sourceLoanMny; // 借款金额
    @TableField(value="source_repaid_loan_mny")
    private BigDecimal sourceRepaidLoanMny; // 已还款金额
    @TableField(value="source_left_loan_mny")
    private BigDecimal sourceLeftLoanMny; // 借款余额
    @TableField(value="cur_repay_mny")
    private BigDecimal curRepayMny; // 本次还款金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_borrowing_person_id")
    private Long sourceBorrowingPersonId; // 借款人id
    @TableField(value="source_borrowing_person_code")
    private String sourceBorrowingPersonCode; // 借款人编码
    @TableField(value="source_borrowing_person_name")
    private String sourceBorrowingPersonName; // 借款人名称
    @TableField(value="source_borrowing_project_id")
    private Long sourceBorrowingProjectId; // 借款人所在项目id
    @TableField(value="source_borrowing_project_code")
    private String sourceBorrowingProjectCode; // 借款人所在项目编码
    @TableField(value="source_borrowing_project_name")
    private String sourceBorrowingProjectName; // 借款人所在项目名称
    @TableField(value="person_repay_id")
    private Long personRepayId; // 个人还款id
    
    
    

    public Long getSourceLoanId() {
        return sourceLoanId;
    }

    public void setSourceLoanId(Long sourceLoanId) {
        this.sourceLoanId = sourceLoanId;
    }
    public String getSourceLoanCode() {
        return sourceLoanCode;
    }

    public void setSourceLoanCode(String sourceLoanCode) {
        this.sourceLoanCode = sourceLoanCode;
    }
    public String getSourceLoanName() {
        return sourceLoanName;
    }

    public void setSourceLoanName(String sourceLoanName) {
        this.sourceLoanName = sourceLoanName;
    }
    public Date getSourceLoanDate() {
        return sourceLoanDate;
    }

    public void setSourceLoanDate(Date sourceLoanDate) {
        this.sourceLoanDate = sourceLoanDate;
    }
    public Date getSourceExpectRepayDate() {
        return sourceExpectRepayDate;
    }

    public void setSourceExpectRepayDate(Date sourceExpectRepayDate) {
        this.sourceExpectRepayDate = sourceExpectRepayDate;
    }
    public BigDecimal getSourceLoanMny() {
        return sourceLoanMny;
    }

    public void setSourceLoanMny(BigDecimal sourceLoanMny) {
        this.sourceLoanMny = sourceLoanMny;
    }
    public BigDecimal getSourceRepaidLoanMny() {
        return sourceRepaidLoanMny;
    }

    public void setSourceRepaidLoanMny(BigDecimal sourceRepaidLoanMny) {
        this.sourceRepaidLoanMny = sourceRepaidLoanMny;
    }
    public BigDecimal getSourceLeftLoanMny() {
        return sourceLeftLoanMny;
    }

    public void setSourceLeftLoanMny(BigDecimal sourceLeftLoanMny) {
        this.sourceLeftLoanMny = sourceLeftLoanMny;
    }
    public BigDecimal getCurRepayMny() {
        return curRepayMny;
    }

    public void setCurRepayMny(BigDecimal curRepayMny) {
        this.curRepayMny = curRepayMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSourceBorrowingPersonId() {
        return sourceBorrowingPersonId;
    }

    public void setSourceBorrowingPersonId(Long sourceBorrowingPersonId) {
        this.sourceBorrowingPersonId = sourceBorrowingPersonId;
    }
    public String getSourceBorrowingPersonCode() {
        return sourceBorrowingPersonCode;
    }

    public void setSourceBorrowingPersonCode(String sourceBorrowingPersonCode) {
        this.sourceBorrowingPersonCode = sourceBorrowingPersonCode;
    }
    public String getSourceBorrowingPersonName() {
        return sourceBorrowingPersonName;
    }

    public void setSourceBorrowingPersonName(String sourceBorrowingPersonName) {
        this.sourceBorrowingPersonName = sourceBorrowingPersonName;
    }
    public Long getSourceBorrowingProjectId() {
        return sourceBorrowingProjectId;
    }

    public void setSourceBorrowingProjectId(Long sourceBorrowingProjectId) {
        this.sourceBorrowingProjectId = sourceBorrowingProjectId;
    }
    public String getSourceBorrowingProjectCode() {
        return sourceBorrowingProjectCode;
    }

    public void setSourceBorrowingProjectCode(String sourceBorrowingProjectCode) {
        this.sourceBorrowingProjectCode = sourceBorrowingProjectCode;
    }
    public String getSourceBorrowingProjectName() {
        return sourceBorrowingProjectName;
    }

    public void setSourceBorrowingProjectName(String sourceBorrowingProjectName) {
        this.sourceBorrowingProjectName = sourceBorrowingProjectName;
    }
    public Long getPersonRepayId() {
        return personRepayId;
    }

    public void setPersonRepayId(Long personRepayId) {
        this.personRepayId = personRepayId;
    }
    
}
