package com.ejianc.business.report.mapper;

import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.report.vo.IncomeContractVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 项目报表 Mapper 接口
 */
@Mapper
public interface ProjectReportMapper{

    //查施工合同金额和施工合同金额(不含暂列金额)
    List<IncomeContractVO> queryIncomeContractMny(@Param("projectIds") List<Long> projectIds);
    //查工程造价变更金额
    List<Map<String, Object>> queryCostAdjustTaxMny(@Param("projectIds") List<Long> projectIds);
    //查工程造价金额
    List<Map<String, Object>> queryCostAdjustMoney(@Param("projectIds") List<Long> projectIds);
    //查定案金额
    List<Map<String, Object>> queryCheckTaxMny(@Param("projectIds") List<Long> projectIds);
    //查变更后收入预算
    List<Map<String, Object>> queryBudgetTaxMny(@Param("projectIds") List<Long> projectIds);

    //根据项目查目标责任成本总金额
    List<Map<String,Object>> queryTargetCostByProjectId(@Param("projectId") Long projectId);
    //根据项目查目标责任成本明细
    List<Map<String,Object>> queryTargetCostDetailByIds(@Param("targetCostIds") List<Long> targetCostIds);

    //查询项目池信息
    List<ContractPoolVO> queryContractPoolByProjectId(@Param("projectId") Long projectId);

    //查询结算池信息
    List<SettlePoolVO> querySettlePoolByProjectId(@Param("projectId") Long projectId,@Param("sourceTypes") List<String> sourceTypes);

    List<BigDecimal> queryCostByProjectId(@Param("projectId") Long projectId);
    //查询成本呢单据子表信息
    List<HandshareDetailVO> queryCostDetailByProjectId(@Param("projectId") Long projectId,@Param("subjectIds") List<Long> subjectIds);
}
