/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.profinance.plan.bean.PlanEntity;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.business.profinance.plan.service.IPlanService;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.business.profinance.plan.vo.PlanContractVO;
import com.ejianc.business.profinance.plan.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"plan"})
public class PlanController
implements Serializable {
    private static final long serialVersionUID = -617427815571056809L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "PROJECT_FUNDS_PLAN";
    private static final String BILL_CODE = "EJCBT202208000018";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final SessionManager sessionManager;
    private final IPlanService service;
    private final IPlanContractService planContractService;
    private final IPlanMaterialService planMaterialService;
    private final IPlanTemporaryService planTemporaryService;
    private final IPlanFeeService planFeeService;

    public PlanController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, SessionManager sessionManager, IPlanService service, IPlanContractService planContractService, IPlanMaterialService planMaterialService, IPlanTemporaryService planTemporaryService, IPlanFeeService planFeeService) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.sessionManager = sessionManager;
        this.service = service;
        this.planContractService = planContractService;
        this.planMaterialService = planMaterialService;
        this.planTemporaryService = planTemporaryService;
        this.planFeeService = planFeeService;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO saveOrUpdateVO) {
        PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.service.checkOnlyOne(entity.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u9879\u76ee\u8d44\u91d1\u8ba1\u5212");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.setSubDefaultValue(entity);
        this.service.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        vo.setPlanContractList(TreeNodeBUtil.buildTree((List)vo.getPlanContractList()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = (PlanEntity)((Object)this.service.selectById(id));
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getPlanContractList())) {
            for (PlanContractVO planContractVO : vo.getPlanContractList()) {
                planContractVO.setTid(planContractVO.getId().toString());
                planContractVO.setTpid(planContractVO.getParentId() != null ? planContractVO.getParentId().toString() : null);
            }
            vo.setPlanContractList(TreeNodeBUtil.buildTree((List)vo.getPlanContractList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        List plans = BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)plans);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        ArrayList plans = new ArrayList();
        page.getRecords().forEach(e -> {
            PlanVO PlanVO2 = (PlanVO)BeanMapper.map((Object)e, PlanVO.class);
            PlanVO2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)PlanVO2.getBillState()).getDescription());
            plans.add(PlanVO2);
        });
        HashMap beans = new HashMap();
        beans.put("records", plans);
        ExcelExport.getInstance().export("plan-export.xlsx", beans, response);
    }

    @PostMapping(value={"/checkReferQuote"})
    public CommonResponse<String> checkReferQuote(@RequestBody JSONObject referMap) {
        this.service.checkReferQuote(referMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @GetMapping(value={"/fetchValue"})
    public CommonResponse<Map<String, Object>> fetchValue(@RequestParam(value="projectId", required=true) Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.fetchValue(projectId));
    }

    @PostMapping(value={"/fetchContractValue"})
    public CommonResponse<Map<String, Object>> fetchContractValue(@RequestBody Collection<Long> contractIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.planContractService.fetchContractValue(contractIds));
    }

    @PostMapping(value={"/fetchMaterialValue"})
    public CommonResponse<Map<String, Object>> fetchMaterialValue(@RequestBody Collection<Long> settleIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.planMaterialService.fetchMaterialValue(settleIds));
    }

    @PostMapping(value={"/fetchTemporaryValue"})
    public CommonResponse<Map<String, Object>> fetchTemporaryValue(@RequestBody Collection<Long> settleIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.planTemporaryService.fetchTemporaryValue(settleIds));
    }

    @PostMapping(value={"/fetchFeeValue"})
    public CommonResponse<Map<String, Object>> fetchFeeValue(@RequestBody Collection<Long> feeIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.planFeeService.fetchFeeValue(feeIds));
    }
}

