package com.ejianc.business.performance.service.impl;

import com.ejianc.business.performance.bean.PerformanceContractEntity;
import com.ejianc.business.performance.bean.PerformanceDeductedEntity;
import com.ejianc.business.performance.service.IPerformanceContractService;
import com.ejianc.business.performance.service.IPerformanceDeductedService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@Service("performanceDeducted") 
public class PerformanceDeductedBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPerformanceDeductedService performanceDeductedService;

	@Autowired
	private IPerformanceContractService contractService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//推送财务中间库
		CommonResponse<String> stringCommonResponse = performanceDeductedService.pushDataToFinance(billId);
		if (!stringCommonResponse.isSuccess()) {
			return stringCommonResponse;
		}
		PerformanceDeductedEntity performanceDeductedEntity = performanceDeductedService.selectById(billId);

		//更改已扣、代缴金额
		QueryParam queryParam1 = new QueryParam();
		queryParam1.getParams().put("projectId",new Parameter(QueryParam.EQ, performanceDeductedEntity.getProjectId()));
		List<PerformanceDeductedEntity> performanceDeductedEntities = performanceDeductedService.queryList(queryParam1);
		BigDecimal deductedMnySum = BigDecimal.ZERO;//已扣款金额
		if(CollectionUtils.isNotEmpty(performanceDeductedEntities)){
			deductedMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getDeductedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
		}
		BigDecimal amountDue = performanceDeductedEntity.getAmountDue();//应缴金额
		//更改承包合同的字段
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(1,3)));
		queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, performanceDeductedEntity.getProjectId()));
		queryParam.getParams().put("payType",new Parameter(QueryParam.IN, Arrays.asList(1)));
		queryParam.getParams().put("withholdingType",new Parameter(QueryParam.IN, Arrays.asList(1)));
		queryParam.getParams().put("performanceBondReturn",new Parameter(QueryParam.IN, Arrays.asList(1)));//履约保证金未退还
		List<PerformanceContractEntity> performanceContractEntities = contractService.queryList(queryParam);
		if(CollectionUtils.isNotEmpty(performanceContractEntities)){
			PerformanceContractEntity performanceContractEntity = performanceContractEntities.get(0);
			performanceContractEntity.setAlreadyDeductedAmount(deductedMnySum);//已扣金额
			performanceContractEntity.setRemainAmount(performanceContractEntity.getAmountDue().subtract(deductedMnySum));
			contractService.saveOrUpdate(performanceContractEntity, false);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("已推送财务付款，无法撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
