package com.ejianc.business.profinance.bean;


import java.util.List;
import java.util.ArrayList;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 一建广联达项目对应实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_glodon_project_relate")
public class GlodonProjectRelateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 项目所属项目部ID
    @TableField(value="org_code")
    private String orgCode; // 项目所属项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目所属项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属上级组织ID
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属上级组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="memo")
    private String memo; // 备注  非必填，0-500字
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称（申请人）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="glodonProjectRelateDetailService", pidName="relateId")//此处有pid="xxx"，默认值pid="pid"
    private List<GlodonProjectRelateDetailEntity> detailList = new ArrayList<>(); // 一建广联达项目对应子实体
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public List<GlodonProjectRelateDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<GlodonProjectRelateDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
