package com.ejianc.business.profinance.person.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.person.bean.PersonRepayDetailEntity;
import com.ejianc.business.profinance.person.bean.PersonRepayEntity;
import com.ejianc.business.profinance.person.service.IPersonLoanService;
import com.ejianc.business.profinance.person.service.IPersonRepayService;
import com.ejianc.business.profinance.person.vo.PersonLoanVO;
import com.ejianc.business.profinance.person.vo.PersonRepayDetailVO;
import com.ejianc.business.profinance.person.vo.PersonRepayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 借款管理-个人还款
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("personRepay")
public class PersonRepayController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPersonLoanService loanService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPersonRepayService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersonRepayVO> saveOrUpdate(@RequestBody PersonRepayVO saveOrUpdateVO) {
    	PersonRepayEntity entity = BeanMapper.map(saveOrUpdateVO, PersonRepayEntity.class);
    	if(entity.getId() == null){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<PersonRepayDetailVO> detailList = saveOrUpdateVO.getDetailList();
        List<Long> delIds = new ArrayList<>();
        List<Long> addIds = new ArrayList<>();
        for (PersonRepayDetailVO vo:detailList){
    	    if (vo.getRowState()!=null&&vo.getRowState().equals("del")){
                Long sourceLoanId = vo.getSourceLoanId();

                delIds.add(sourceLoanId);
            }
    	    if (vo.getRowState()!=null&&vo.getRowState().equals("add")){
                addIds.add(vo.getSourceLoanId());

            }
        }
        if (!delIds.isEmpty()){
            loanService.updateColumnValue(delIds,"ref_status","未引用");
        }
        if (!addIds.isEmpty()){
            loanService.updateColumnValue(addIds,"ref_status","引用");
        }
    	service.saveOrUpdate(entity, false);
        PersonRepayVO vo = BeanMapper.map(entity, PersonRepayVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersonRepayVO> queryDetail(Long id) {
    	PersonRepayEntity entity = service.selectById(id);
    	PersonRepayVO vo = BeanMapper.map(entity, PersonRepayVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonRepayVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PersonRepayVO vo : vos) {
                PersonRepayEntity repayEntity = service.selectById(vo.getId());
                List<PersonRepayDetailEntity> detailList = repayEntity.getDetailList();
                List<Long> sourceLoanIds = detailList.stream().map(PersonRepayDetailEntity::getSourceLoanId).collect(Collectors.toList());
                loanService.updateColumnValue(sourceLoanIds,"ref_status","未引用");
            }
        }
        service.removeByIds(vos.stream().map(PersonRepayVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("repayProjectName");
        fuzzyFields.add("repayPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ,orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        // 金额合计
        Map<String, BigDecimal> map = service.fetchTotalMny(param);
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PersonRepayEntity> page = service.queryPage(param,false);
        List<PersonRepayVO> personRepayVOS = BeanMapper.mapList(page.getRecords(), PersonRepayVO.class);
        resp.put("current", page.getCurrent());
        resp.put("size", page.getSize());
        resp.put("pages", page.getPages());
        resp.put("total", page.getTotal());
        resp.put("records", personRepayVOS);
        resp.put("totalCurTotalRepayMny", map.get("totalCurTotalRepayMny"));
        return CommonResponse.success("查询列表数据成功！", resp);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> jsonObjectCommonResponse = queryList(param);
        List<PersonRepayVO> list = new ArrayList<>();
        if (null != jsonObjectCommonResponse.getData()){
            list = (List<PersonRepayVO>) jsonObjectCommonResponse.getData().get("records");
            list.forEach(c->{
                c.setBillStateStr(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonRepay-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPersonRepayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PersonRepayVO>> refPersonRepayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PersonRepayEntity> page = service.queryPage(param,false);
        IPage<PersonRepayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersonRepayVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
