package com.ejianc.business.profinance.plan.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Collection;

/**
 * 项目资金计划-支出合同
 *
 * @author generator
 */
public interface IPlanContractService extends IBaseService<PlanContractEntity> {

	/**
	 * 根据项目资金计划id，修改项目资金计划-支出合同的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	void updateBillState(Long planId, Integer billStateCode);

	/**
	 * 根据合同ids查询累计结算金额、累计申请预付款(不含本次)、累计已扣减预付款(不含本次)、累计申请进度款(不含本次)、累计已申请付款(不含本次)
	 *
	 * @param contractIds 合同id集合
	 *
	 * @return 累计结算金额、累计申请预付款(不含本次)、累计已扣减预付款(不含本次)、累计申请进度款(不含本次)、累计已申请付款(不含本次)
	 */
	JSONObject fetchContractValue(Collection<Long> contractIds);
}
