package com.ejianc.business.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPerformance.api.IPMPerformanceApi;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReceiptVO;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.performance.bean.PerformanceContractEntity;
import com.ejianc.business.performance.bean.PerformanceRecordEntity;
import com.ejianc.business.performance.service.IPerformanceContractService;
import com.ejianc.business.performance.service.IPerformanceRecordService;
import com.ejianc.business.performance.vo.PerformanceDeductedVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.performance.mapper.PerformanceDeductedMapper;
import com.ejianc.business.performance.bean.PerformanceDeductedEntity;
import com.ejianc.business.performance.service.IPerformanceDeductedService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 履约保证金扣款
 * 
 * @author generator
 * 
 */
@Service("performanceDeductedService")
public class PerformanceDeductedServiceImpl extends BaseServiceImpl<PerformanceDeductedMapper, PerformanceDeductedEntity> implements IPerformanceDeductedService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IPerformanceRecordService performanceRecordService;
    @Autowired
    private IPerformanceContractService contractService;
    @Autowired
    private IPMPerformanceApi performanceApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    //履约保证金收款结果处理
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessageReceipt(String receiptResultMsg) {
        /*
            获取收款单数据
            1.存入缓存中间库
            2.判断是否已经推送
            3.未推送判断是否需要推送
            4、组装并推送数据
         */
        logger.info("获取收款单数据，开始生成扣款单--begin！");

        if (StringUtils.isNotBlank(receiptResultMsg)){
            List<PMPerformanceReceiptVO> resultList = JSONObject.parseArray(receiptResultMsg, PMPerformanceReceiptVO.class);
            logger.info("接收一建财务系统的履约保证金收款结果：{}", JSONObject.toJSONString(resultList));
            if (CollectionUtils.isNotEmpty(resultList)){
                //1.存入缓存中间库
                List<PerformanceRecordEntity> saveList = new ArrayList<>();
                List<String> cwBillCodeList = new ArrayList<>();
                for (PMPerformanceReceiptVO pmPerformanceReceiptVO : resultList) {
                    PerformanceRecordEntity performanceRecordEntity = new PerformanceRecordEntity();
                    performanceRecordEntity.setProjectId(Long.getLong(pmPerformanceReceiptVO.getProjectId()));
                    performanceRecordEntity.setBillCode(pmPerformanceReceiptVO.getBillCode());
                    performanceRecordEntity.setMny(pmPerformanceReceiptVO.getMny());
                    performanceRecordEntity.setHxMny(pmPerformanceReceiptVO.getHxMny());
                    performanceRecordEntity.setSkMny(pmPerformanceReceiptVO.getSkMny());
                    performanceRecordEntity.setBillDate(pmPerformanceReceiptVO.getCreateTime());
                    performanceRecordEntity.setCreateUserCode("SYSTEM");
                    performanceRecordEntity.setTenantId(999999L);
                    cwBillCodeList.add(pmPerformanceReceiptVO.getBillCode());
                    saveList.add(performanceRecordEntity);
                }
                performanceRecordService.saveOrUpdateBatch(saveList);
                //2.判断是否已经推送
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("receiveBillCode",new Parameter(QueryParam.IN,cwBillCodeList));
                List<PerformanceDeductedEntity> performanceDeductedEntities = super.queryList(queryParam);

                Map<String, PerformanceDeductedEntity> collect = new HashMap<>();
                if (CollectionUtils.isNotEmpty(performanceDeductedEntities)){
                    //已推送
                    collect = performanceDeductedEntities.stream().collect(Collectors.toMap(PerformanceDeductedEntity::getReceiveBillCode, Function.identity(), (v1, v2) -> v2));
                }

                createDeductedByResultList(resultList,collect);
            }
        }
        logger.info("获取收款单数据，开始生成扣款单--end！");
    }

    //根据收款数据自动生成扣款单
    private void createDeductedByResultList(List<PMPerformanceReceiptVO> resultList,Map<String, PerformanceDeductedEntity> map) {
       for (PMPerformanceReceiptVO pmPerformanceReceiptVO : resultList) {
            if (!map.containsKey(pmPerformanceReceiptVO.getBillCode())){//未推送
                QueryParam queryParam = new QueryParam();
                //1.缴纳方式为：工程款或预付款，
                //2.扣款类型为：比例收取
                //3.履约保证金未退还
                queryParam.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(1,3)));
                queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, pmPerformanceReceiptVO.getProjectId()));
                queryParam.getParams().put("payType",new Parameter(QueryParam.IN, Arrays.asList(1)));
                queryParam.getParams().put("withholdingType",new Parameter(QueryParam.IN, Arrays.asList(1)));
                queryParam.getParams().put("performanceBondReturn",new Parameter(QueryParam.IN, Arrays.asList(1)));//履约保证金未退还
                List<PerformanceContractEntity> performanceContractEntities = contractService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(performanceContractEntities)) {

                    /*
                    1.应扣金额：所有的收款金额*10% 与 本项目应扣金额 比较，谁小取谁
                    2.已扣金额：所有的扣款金额之和
                    3.本次扣款： 应扣金额-已扣金额
                     */
                    PerformanceContractEntity performanceContractEntity = performanceContractEntities.get(0);
                    //金额判断，获取之前所有扣款单的金额，不能大于（工程造价2000W为20W，>2000W为1%）
//                    BigDecimal projectCost = performanceContractEntity.getProjectCost();
                    BigDecimal amountDue = performanceContractEntity.getAmountDue();//本项目应扣金额
//                    if (projectCost.compareTo(new BigDecimal("2000")) > 0){
//                        amountDue = projectCost.multiply(new BigDecimal("0.01"));
//                    }
                    QueryParam queryParam1 = new QueryParam();
                    queryParam1.getParams().put("projectId",new Parameter(QueryParam.EQ, pmPerformanceReceiptVO.getProjectId()));
                    List<PerformanceDeductedEntity> performanceDeductedEntities = super.queryList(queryParam1);

                    BigDecimal receiptMnySum = BigDecimal.ZERO;//所有的收款金额
                    BigDecimal deductedMnySum = BigDecimal.ZERO;//已扣款金额
                    if(CollectionUtils.isNotEmpty(performanceDeductedEntities)){
                        deductedMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getDeductedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        receiptMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    receiptMnySum = receiptMnySum.add(pmPerformanceReceiptVO.getMny()).multiply(new BigDecimal("0.1"));

                    //应扣金额 receiptMnySum和amountDue比较，谁小取谁
                    BigDecimal shouldDeductedMny = receiptMnySum.compareTo(amountDue) > 0 ? amountDue : receiptMnySum;

                    //剩余扣款金额 = 应扣金额-已扣款金额
                    BigDecimal remainAmount = shouldDeductedMny.subtract(deductedMnySum);

                    //组装扣款单的数据
                    PerformanceDeductedEntity performanceDeductedEntity = new PerformanceDeductedEntity();
                    performanceDeductedEntity.setContractId(performanceContractEntity.getId());
                    performanceDeductedEntity.setProjectId(performanceContractEntity.getProjectId());
                    performanceDeductedEntity.setProjectCode(performanceContractEntity.getProjectCode());
                    performanceDeductedEntity.setProjectName(performanceContractEntity.getProjectName());
                    performanceDeductedEntity.setOrgId(performanceContractEntity.getOrgId());
                    performanceDeductedEntity.setOrgCode(performanceContractEntity.getOrgCode());
                    performanceDeductedEntity.setOrgName(performanceContractEntity.getOrgName());
                    performanceDeductedEntity.setParentOrgId(performanceContractEntity.getParentOrgId());
                    performanceDeductedEntity.setParentOrgCode(performanceContractEntity.getParentOrgCode());
                    performanceDeductedEntity.setParentOrgName(performanceContractEntity.getParentOrgName());
                    performanceDeductedEntity.setBillDate(new Date());
                    performanceDeductedEntity.setReceiveMny(pmPerformanceReceiptVO.getMny());//收款金额
                    performanceDeductedEntity.setReceiveBillCode(pmPerformanceReceiptVO.getBillCode());
                    performanceDeductedEntity.setReceiveBillType("财务系统收款");
                    performanceDeductedEntity.setReceiveDate(pmPerformanceReceiptVO.getCreateTime());
                    performanceDeductedEntity.setDeductedMny(remainAmount);//本次扣款金额
                    performanceDeductedEntity.setDeductedPercent(new BigDecimal("10"));
                    performanceDeductedEntity.setDeductedType("自动生成扣款单");

                    performanceDeductedEntity.setAmountDue(amountDue);
                    performanceDeductedEntity.setAlreadyDeductedAmount(deductedMnySum);
                    performanceDeductedEntity.setRemainAmount(amountDue.subtract(deductedMnySum));
                    performanceDeductedEntity.setCreateUserCode("SYSTEM");
                    performanceDeductedEntity.setTenantId(999999L);
                    performanceDeductedEntity.setPayState(1);

                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),new PerformanceDeductedVO());
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        performanceDeductedEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    super.saveOrUpdate(performanceDeductedEntity, false);
                }
            }
        }

    }


    @Override
    public CommonResponse<String> pushDataToFinance(Long billId){
        PerformanceDeductedEntity performanceDeductedEntity = super.selectById(billId);
        if (performanceDeductedEntity != null) {
            if (performanceDeductedEntity.getPayState() == 2) {
                return CommonResponse.error("该单已推送财务，请勿重复操作！");
            }
            List<PMPerformanceVO> vo = new ArrayList<>();

            PMPerformanceVO performanceVO = new PMPerformanceVO();
            performanceVO.setId(IdWorker.getId()+"");
            performanceVO.setPmBillId(performanceDeductedEntity.getId()+"");
            performanceVO.setProjectId(performanceDeductedEntity.getProjectId()+ "");
            performanceVO.setQuoteFlag("N");
//            performanceVO.setCreateTime();
            performanceVO.setActualMny(performanceDeductedEntity.getDeductedMny());
            vo.add(performanceVO);

            //执行推送操作
            CommonResponse<PMPerformanceVO> pmPerformanceVOCommonResponse = performanceApi.performanceTakeEffect(vo);
            if (pmPerformanceVOCommonResponse.isSuccess()) {
                //更改推送状态
                performanceDeductedEntity.setPayState(2);
                super.updateById(performanceDeductedEntity);



                return CommonResponse.success("推送财务成功！");
            }else{
                return CommonResponse.error("推送财务失败！");
            }
        }else {
            return CommonResponse.error("获取单据信息失败！");
        }

    }

    //履约保证金扣款数据支付状态处理
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessageDeducted(String deductedResultMsg) {
        /*
            获取要更新状态的数据
         */
        logger.info("获取扣款单支付数据--begin！");

        if (StringUtils.isNotBlank(deductedResultMsg)){
            List<PMPerformanceVO> resultList = JSONObject.parseArray(deductedResultMsg, PMPerformanceVO.class);
            logger.info("接收一建财务系统的履约保证金扣款数据结果：{}", JSONObject.toJSONString(resultList));
            if (CollectionUtils.isNotEmpty(resultList)){
                //
                List<String> deductedIds = resultList.stream().map(PMPerformanceVO::getPmBillId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter(QueryParam.IN, deductedIds));
                List<PerformanceDeductedEntity> performanceDeductedEntities = super.queryList(queryParam);
                Map<Long, PerformanceDeductedEntity> collect = performanceDeductedEntities.stream().collect(Collectors.toMap(PerformanceDeductedEntity::getId, Function.identity(), (v1, v2) -> v2));

                for (PMPerformanceVO pMPerformanceVO : resultList) {
                    if(collect.containsKey(Long.parseLong(pMPerformanceVO.getPmBillId()))){
                        PerformanceDeductedEntity performanceDeductedEntity = collect.get(Long.parseLong(pMPerformanceVO.getPmBillId()));
                        if(pMPerformanceVO.getState() != null){
                            if("1".equals(pMPerformanceVO.getState())){
                                performanceDeductedEntity.setPayState(3);//支付成功
                            }else if("2".equals(pMPerformanceVO.getState())){
                                performanceDeductedEntity.setPayState(4);//支付失败
                            }
                            super.updateById(performanceDeductedEntity);
                        }
                    }
                }
            }
        }

        logger.info("获取收款单数据，开始生成扣款单--end！");
    }

}
