package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PMPayEntity;
import com.ejianc.business.profinance.service.IPMPayService;
import com.ejianc.business.profinance.vo.PMPayVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * PM支付主实体
 *
 * @author generator
 */
@RestController
public class PMPayApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMPayService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/api/pmPayApi/syncPayment", method = RequestMethod.POST)
    public CommonResponse<String> saveOrUpdate(@RequestBody String param) {
        logger.info("接收到付款结果-{}", param);
        if(StringUtils.isBlank(param)) {
            return CommonResponse.error("处理支付结果信息失败，参数为空！");
        }
        PMPayEntity entity;
        List<PMPayEntity> pmPayEntityList = new ArrayList<>();
        try {
            List<Map> mapList = JSONObject.parseArray(param, Map.class);
            List<String> sourceIdList = new ArrayList<>();
            QueryWrapper<PMPayEntity> repeatCheck = null;
            for (Map paymentMap : mapList) {
                entity = null;
                // 非空校验
                if (null == paymentMap.get("projectId") || StringUtils.isBlank(paymentMap.get("projectId").toString())) {
                    return CommonResponse.error("参数 projectId 不能为空！");
                }
                if (null == paymentMap.get("supplyId") || StringUtils.isBlank(paymentMap.get("supplyId").toString())) {
                    return CommonResponse.error("参数 supplyId 不能为空！");
                }
                if (null == paymentMap.get("contractId") || StringUtils.isBlank(paymentMap.get("contractId").toString())) {
                    return CommonResponse.error("参数 contractId 不能为空！");
                }
                if (null == paymentMap.get("payeeId") || StringUtils.isBlank(paymentMap.get("payeeId").toString())) {
                    return CommonResponse.error("参数 payeeId 不能为空！");
                }
                if (null == paymentMap.get("payMnyActual") || StringUtils.isBlank(paymentMap.get("payMnyActual").toString())) {
                    return CommonResponse.error("参数 payMnyActual 不能为空！");
                }
                if (null == paymentMap.get("sourceId") || StringUtils.isBlank(paymentMap.get("sourceId").toString())) {
                    return CommonResponse.error("参数 sourceId 不能为空！");
                }
                //判断sourceId在本次传输参数中是否重复
                if(null != paymentMap.get("id") && StringUtils.isNotBlank(paymentMap.get("id").toString())) {
                    if(sourceIdList.contains(paymentMap.get("id").toString())) {
                        return CommonResponse.error("付款唯一标识id【"+paymentMap.get("id").toString()+"】 重复！");
                    }
                    //数据库判重
                    repeatCheck = new QueryWrapper<>();
                    repeatCheck.eq("source_id", paymentMap.get("id").toString());
                    repeatCheck.in("paid_flag", new Integer[]{0, 1, 3}); //待核销和核销成功的记录
                    List<PMPayEntity> repeatList = service.list(repeatCheck);
                    if(CollectionUtils.isNotEmpty(repeatList)) {
                        return CommonResponse.error("付款唯一标识 id【"+paymentMap.get("id").toString()+"】 重复，核销失败！");
                    }
                    //将原有sourceId记录到ext1中
                    paymentMap.put("ext1", null != paymentMap.get("sourceId") ? paymentMap.get("sourceId").toString() : null);
                    paymentMap.put("sourceId", paymentMap.get("id").toString()); //将id覆盖到sourceId中
                    sourceIdList.add(paymentMap.get("id").toString());
                    paymentMap.put("id", null); //id设置为null,否则类型转化时会报错
                }

                entity = BeanMapper.map(paymentMap, PMPayEntity.class);

                //根据财务单据编号以及实付金额判重
                QueryWrapper<PMPayEntity> repeatCheckMny = new QueryWrapper<>();
                repeatCheckMny.eq("ext1", entity.getExt1());
                repeatCheckMny.eq("pay_mny_actual", entity.getPayMnyActual());
                List<PMPayEntity> repeatListMny = service.list(repeatCheckMny);
                if(CollectionUtils.isNotEmpty(repeatListMny)) {
                    return CommonResponse.error("付款单编号【"+entity.getExt1()+"】+金额 重复，核销失败！");
                }


                entity.setId(IdWorker.getId());
                if (null == paymentMap.get("pushTime") || StringUtils.isBlank(paymentMap.get("pushTime").toString())) {
                    entity.setPushTime(new Date());
                } else {
                    entity.setPushTime(new Date(Long.parseLong(paymentMap.get("pushTime").toString())));
                }
                // 默认为未核销
                entity.setPaidFlag(0);
                //数据来源设置为财务系统推送
                entity.setSourceType(PMPayVO.SOURCE_TYPE_FINANCY_SYS);
                entity.setSourceTypeCode(PMPayVO.SOURCE_TYPE_CODE_FINANCY_SYS);

                //接受实际支付时间
                if(null != paymentMap.get("actualPayTime") && StringUtils.isBlank(paymentMap.get("actualPayTime").toString())) {
                    entity.setActualPayTime(new Date(Long.parseLong(paymentMap.get("actualPayTime").toString())));
                } else {
                    logger.info("付款通知单-【{}】实付时间为空！", param);
                }
//                pmPayEntityList.add(entity);

                // 保存
                service.saveOrUpdate(entity, false);
                service.sendMessage(BeanMapper.map(entity, PMPayVO.class));
            }

            // 保存
//            service.saveOrUpdateBatch(pmPayEntityList, pmPayEntityList.size(), false);


            logger.info("付款结果信息: 【{}】保存并发送队列成功！", param);
            return CommonResponse.success("付款结果信息处理成功！");
        } catch (Exception e) {
            logger.error("付款结果信息{}转换异常", param, e);
            return CommonResponse.error("付款结果信息处理失败！");
        }
    }

}
