package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.income.vo.SettlementFinalizationDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工程结算定案表返回确认单主实体
 * 
 * @author generator
 * 
 */
public class SettlementFinalizationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal contractTaxMny; // 合同金额(含税)
    private Long constructId; // 建设单位id
    private String constructName; // 建设单位
    private Long checkUnitId; // 审核单位id
    private String checkUnit; // 审核单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
    private BigDecimal sumProductionMny; // 累计产值
    private BigDecimal sumCostMny; // 累计成本
    private BigDecimal sumReceiptMny; // 累计收款金额
    private BigDecimal censorshipSettlementMny; // 送审结算金额
    private BigDecimal censorshipSettlementTaxMny; // 送审结算金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date censorshipDate; // 送审日期
    private String finalizationStage; // 定案阶段
    private Integer finalJudgment; // 是否终审 0-否 1-是
    private Integer governmentAudit; // 是否政府审计 0-否 1-是
    private String finalizationStageName; // 定案阶段名称：1-一审，2-二审，3-三审，4-终审
    private BigDecimal authorizeMny; // 审定金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date authorizeDate; // 审定日期
    private BigDecimal finalReductionRate; // 最终审减率
    private BigDecimal contractReductionRate; // 合同约定审减率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalizationBackDate; // 定案表返回日期
    private BigDecimal sumFinalizationBackMny; // 定案表返回金额
    private BigDecimal finalizationDifferenceMny; // 定案表返回金额与审定金额之差
    private BigDecimal sumFinalizationOutMny; // 定案表外金额
    private Integer finalizationFormFlag; // 是否取得竣工备案表 0-否 1-是
    private String finalizationFormFlagName; // 是否取得竣工备案表 0-否 1-是
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String billStateName;
    private BigDecimal sumCostTaxMny; // 累计成本
    @TableField(value = "settle_stage")
    private String settleStage; // 结算阶段  固定值【第一阶段、第二阶段、第三阶段、第四阶段、第五阶段】
    @TableField(value = "unit_property")
    private String unitProperty; // 建设单位性质 1-集团内  2-集团外
    private String basicUnitName; // 基层单位名称
    private List<SettlementFinalizationDetailVO> detailList = new ArrayList<>(); // 工程结算定案表返回确认单子实体
    private List<SettlementFinalizationVO> children = new ArrayList<>(); //
    private String childProjectName; // 子项目名称
    private BigDecimal sumProductionTaxMny; // 累计产值

    public Integer getGovernmentAudit() {
        return governmentAudit;
    }

    public void setGovernmentAudit(Integer governmentAudit) {
        this.governmentAudit = governmentAudit;
    }

    public Integer getFinalJudgment() {
        return finalJudgment;
    }

    public void setFinalJudgment(Integer finalJudgment) {
        this.finalJudgment = finalJudgment;
    }

    public String getFinalizationStageName() {
        return finalizationStageName;
    }

    public void setFinalizationStageName(String finalizationStageName) {
        this.finalizationStageName = finalizationStageName;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getCensorshipSettlementTaxMny() {
        return censorshipSettlementTaxMny;
    }

    public void setCensorshipSettlementTaxMny(BigDecimal censorshipSettlementTaxMny) {
        this.censorshipSettlementTaxMny = censorshipSettlementTaxMny;
    }

    public String getChildProjectName() {
        return childProjectName;
    }

    public void setChildProjectName(String childProjectName) {
        this.childProjectName = childProjectName;
    }

    public List<SettlementFinalizationVO> getChildren() {
        return children;
    }

    public void setChildren(List<SettlementFinalizationVO> children) {
        this.children = children;
    }

    public String getBasicUnitName() {
        return basicUnitName;
    }

    public void setBasicUnitName(String basicUnitName) {
        this.basicUnitName = basicUnitName;
    }

    public String getUnitProperty() {
        return unitProperty;
    }

    public void setUnitProperty(String unitProperty) {
        this.unitProperty = unitProperty;
    }

    public String getSettleStage() {
        return settleStage;
    }

    public void setSettleStage(String settleStage) {
        this.settleStage = settleStage;
    }

    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public Long getCheckUnitId() {
        return checkUnitId;
    }
    @ReferDeserialTransfer
    public void setCheckUnitId(Long checkUnitId) {
        this.checkUnitId = checkUnitId;
    }

    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getCensorshipSettlementMny() {
        return censorshipSettlementMny;
    }

    public void setCensorshipSettlementMny(BigDecimal censorshipSettlementMny) {
        this.censorshipSettlementMny = censorshipSettlementMny;
    }
    public Date getCensorshipDate() {
        return censorshipDate;
    }

    public void setCensorshipDate(Date censorshipDate) {
        this.censorshipDate = censorshipDate;
    }
    public String getFinalizationStage() {
        return finalizationStage;
    }

    public void setFinalizationStage(String finalizationStage) {
        this.finalizationStage = finalizationStage;
    }
    public BigDecimal getAuthorizeMny() {
        return authorizeMny;
    }

    public void setAuthorizeMny(BigDecimal authorizeMny) {
        this.authorizeMny = authorizeMny;
    }
    public Date getAuthorizeDate() {
        return authorizeDate;
    }

    public void setAuthorizeDate(Date authorizeDate) {
        this.authorizeDate = authorizeDate;
    }
    public BigDecimal getFinalReductionRate() {
        return finalReductionRate;
    }

    public void setFinalReductionRate(BigDecimal finalReductionRate) {
        this.finalReductionRate = finalReductionRate;
    }
    public BigDecimal getContractReductionRate() {
        return contractReductionRate;
    }

    public void setContractReductionRate(BigDecimal contractReductionRate) {
        this.contractReductionRate = contractReductionRate;
    }
    public Date getFinalizationBackDate() {
        return finalizationBackDate;
    }

    public void setFinalizationBackDate(Date finalizationBackDate) {
        this.finalizationBackDate = finalizationBackDate;
    }
    public BigDecimal getSumFinalizationBackMny() {
        return sumFinalizationBackMny;
    }

    public void setSumFinalizationBackMny(BigDecimal sumFinalizationBackMny) {
        this.sumFinalizationBackMny = sumFinalizationBackMny;
    }
    public BigDecimal getFinalizationDifferenceMny() {
        return finalizationDifferenceMny;
    }

    public void setFinalizationDifferenceMny(BigDecimal finalizationDifferenceMny) {
        this.finalizationDifferenceMny = finalizationDifferenceMny;
    }
    public BigDecimal getSumFinalizationOutMny() {
        return sumFinalizationOutMny;
    }

    public void setSumFinalizationOutMny(BigDecimal sumFinalizationOutMny) {
        this.sumFinalizationOutMny = sumFinalizationOutMny;
    }
    public Integer getFinalizationFormFlag() {
        return finalizationFormFlag;
    }

    public void setFinalizationFormFlag(Integer finalizationFormFlag) {
        this.finalizationFormFlag = finalizationFormFlag;
    }

    public String getFinalizationFormFlagName() {
        return finalizationFormFlagName;
    }

    public void setFinalizationFormFlagName(String finalizationFormFlagName) {
        this.finalizationFormFlagName = finalizationFormFlagName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<SettlementFinalizationDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettlementFinalizationDetailVO> detailList) {
        this.detailList = detailList;
    }
}
