package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 其他项清单
 * 
 * @author generator
 * 
 */
public class BudgetOtherVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private String detailIndex; // 序号
    private Long parentId; // 父ID
    private String otherCode; // 编码
    private String otherName; // 名称
    private String otherFeature; // 特征
    private String otherUnit; // 单位
    private java.math.BigDecimal otherNum; // 工程量
    private java.math.BigDecimal otherTaxRate; // 税率
    private java.math.BigDecimal otherPrice; // 综合单价(无税)
    private java.math.BigDecimal otherTaxPrice; // 综合单价(含税)
    private java.math.BigDecimal otherMny; // 合价(无税)
    private java.math.BigDecimal otherTaxMny; // 合价(含税)
    private java.math.BigDecimal otherTax; // 税额
    private String otherMemo; // 备注
    private Boolean leafFlag; // 是否末级
    private List<BudgetDetailVO> detailVos = new ArrayList<>(); // 清单明细

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private Long otherSubjectId; // 成本科目id
    private String otherSubjectName; // 成本科目名称

    private List<ITreeNodeB> children;

    //新增手填 暂不互算
    private BigDecimal otherAdditionalTaxRate; //税率(%含附加税)
    private BigDecimal otherAdditionalTaxPrice; //综合单价(含附加税)
    private BigDecimal otherAdditionalTaxMny; //合价(含附加税)

    public BigDecimal getOtherAdditionalTaxRate() {
        return otherAdditionalTaxRate;
    }

    public void setOtherAdditionalTaxRate(BigDecimal otherAdditionalTaxRate) {
        this.otherAdditionalTaxRate = otherAdditionalTaxRate;
    }

    public BigDecimal getOtherAdditionalTaxPrice() {
        return otherAdditionalTaxPrice;
    }

    public void setOtherAdditionalTaxPrice(BigDecimal otherAdditionalTaxPrice) {
        this.otherAdditionalTaxPrice = otherAdditionalTaxPrice;
    }

    public BigDecimal getOtherAdditionalTaxMny() {
        return otherAdditionalTaxMny;
    }

    public void setOtherAdditionalTaxMny(BigDecimal otherAdditionalTaxMny) {
        this.otherAdditionalTaxMny = otherAdditionalTaxMny;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getOtherSubjectId() {
        return otherSubjectId;
    }
    @ReferDeserialTransfer
    public void setOtherSubjectId(Long otherSubjectId) {
        this.otherSubjectId = otherSubjectId;
    }

    public String getOtherSubjectName() {
        return otherSubjectName;
    }

    public void setOtherSubjectName(String otherSubjectName) {
        this.otherSubjectName = otherSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public List<BudgetDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<BudgetDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getOtherCode() {
        return otherCode;
    }

    /**
     * 编码
     */
    public void setOtherCode(String otherCode) {
        this.otherCode = otherCode;
    }
    /**
     * 名称
     */
    public String getOtherName() {
        return otherName;
    }

    /**
     * 名称
     */
    public void setOtherName(String otherName) {
        this.otherName = otherName;
    }
    /**
     * 特征
     */
    public String getOtherFeature() {
        return otherFeature;
    }

    /**
     * 特征
     */
    public void setOtherFeature(String otherFeature) {
        this.otherFeature = otherFeature;
    }
    /**
     * 单位
     */
    public String getOtherUnit() {
        return otherUnit;
    }

    /**
     * 单位
     */
    public void setOtherUnit(String otherUnit) {
        this.otherUnit = otherUnit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getOtherNum() {
        return otherNum;
    }

    /**
     * 工程量
     */
    public void setOtherNum(java.math.BigDecimal otherNum) {
        this.otherNum = otherNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getOtherTaxRate() {
        return otherTaxRate;
    }

    /**
     * 税率
     */
    public void setOtherTaxRate(java.math.BigDecimal otherTaxRate) {
        this.otherTaxRate = otherTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public java.math.BigDecimal getOtherPrice() {
        return otherPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setOtherPrice(java.math.BigDecimal otherPrice) {
        this.otherPrice = otherPrice;
    }
    /**
     * 综合单价(含税)
     */
    public java.math.BigDecimal getOtherTaxPrice() {
        return otherTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setOtherTaxPrice(java.math.BigDecimal otherTaxPrice) {
        this.otherTaxPrice = otherTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 合价(无税)
     */
    public void setOtherMny(java.math.BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setOtherTaxMny(java.math.BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    /**
     * 备注
     */
    public String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 备注
     */
    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"otherPrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"otherTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"otherNum"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"otherMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"otherTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"otherTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"otherTax"};
    }
}
