package com.ejianc.business.pro.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
public class ContractRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同类型：主合同
     */
    public static final Integer CONTRACT_TYPE_MAIN_CONTRACT = 0;
    /**
     * 合同类型：补充协议
     */
    public static final Integer CONTRACT_TYPE_SUPPLEMENT = 1;

    @ConvertField(targetField = "contractCode")
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long reviewId; // 合同评审
    @ConvertField
    private Long projectId; // 项目
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private String projectCode; // 项目编号
    @ConvertField
    private Long orgId; // 组织
    @ConvertField
    private String orgCode; // 组织编码
    @ConvertField
    private String orgName; // 组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    private Long bearType; // 承揽方式
    @ConvertField
    private String contractName; // 合同名称
//    @ConvertField(targetField = "categoryId")

    @ConvertField
    private Long contractType; // 合同类型


    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId; // 合同类别

    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @ConvertField(targetField = "partyaId")
    private Long customerId; // 合同甲方
    @ConvertField(targetField = "partyaName")
    private String customerName; // 合同甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 合同乙方
    @ConvertField(targetField = "partybName")
    private String supplierName; // 合同乙方名称
    @ConvertField(targetField = "joinPartyName")
    private String constructionPartner; // 施工联合方
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "contractTax")
    private BigDecimal taxMny; // 税额
    @ConvertField
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @ConvertField
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @ConvertField(targetField = "contractStartDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @ConvertField(targetField = "contractFinishDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @ConvertField(targetField = "contractDaysLimit")
    private Integer schedule; // 工期
    @ConvertField
    private Long contractValuationType; // 合同计价形式，档案
    private String contractStatus; // 合同状态：1-履约中, 2-已封账，3-已解除
    @ConvertField(targetField = "partycName")
    private String contractPartyc; // 合同丙方
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    @ConvertField
    private BigDecimal provisionalMny; // 暂列金额
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @ConvertField
    private Long employeeId; // 经办人
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField
    private Long deptId; // 经办部门
    @ConvertField
    private String deptName; // 经办部门名称
    private String memo; // 备注
    @ConvertField(targetField = "baseTaxMny")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @ConvertField(targetField = "baseMny")
    private BigDecimal baseMoney; // 初始版本金额
    @ConvertField(targetField = "baseTax")
    private BigDecimal baseTax; // 初始版本税额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private Integer changeVersion; // 变更版本

    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private String changeReason; // 变更原因
    @ConvertField
    private String mainContractName; // 主合同名称
    @ConvertField
    private Long mainContractId; // 主合同ID
    @ConvertField
    private String mainContractCode; // 主合同编码
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    private BigDecimal sumProductionMny; // 累计产值报量
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    private BigDecimal sumQuoteMny; // 累计甲方报量
    private BigDecimal sumCollectMny; // 累计收款
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private BigDecimal sumInvoicingMny; // 累计开票
    private BigDecimal sumNegotiateMny; // 变更洽商总金额(无税)
    private BigDecimal sumNegotiateTaxMny; // 变更洽商总金额
    private BigDecimal sumVisaMny; // 经济签证总金额(无税)
    private BigDecimal sumVisaTaxMny; // 经济签证总金额
    private BigDecimal sumClaimMny; // 索赔总金额(无税)
    private BigDecimal sumClaimTaxMny; // 索赔总金额
    private BigDecimal sumOperateMny; // 累计变更洽商金额(无税)
    private BigDecimal sumOperateTaxMny; // 累计变更洽商金额
    private BigDecimal sumMaterialSettleMny; // 累计甲供材结算金额(无税)
    private BigDecimal sumMaterialSettleTaxMny; // 累计甲供材结算金额
    @ConvertField
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    private Integer isRelieve; // 是否已解除：0-否，1-是
    private String supplierPhone; // 乙方电话
    private String customerPhone; // 甲方电话
    private String customerEntrustedAgent; // 甲方委托代理人
    private String supplierEntrustedAgent; // 乙方委托代理人
    private Long disputeResolution; // 争议解决方式
    private String disputeResolutionAgency; // 争议解决机构
    
    private Integer reviewVersion; // 施工合同评审版本号
    private String contractStatusName; // 合同状态名称
    private String billStateName; // 单据状态名称
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private String supplementContent; // 协议内容
    private Long contractualModel; // 承包模式
    private Integer isSuspend; // 是否中止：0-否，1-是
    private Long constructId;//建设单位
    private String constructName;//建设单位
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date contractSignDate; // 合同标注签订日期
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date contractStampDate; // 合同盖章日期

    @ConvertField
    private Integer contractBack; // 合同是否返回(1是，2否）
    @ConvertField
    private Integer contractStampNum; // 盖章份数

    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date contractBackDate; // 合同返回日期
    @ConvertField
    private Integer backNum; // 返回份数
    @ConvertField
    private Integer reportJt; // 是否上报集团(1是，2否）

    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reportJtDate; // 合同上报集团时间
    @ConvertField
    private Integer contractPresentation; // 合同是否交底(1是，2否）

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;
    @ConvertField
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)

    @ConvertField
    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    @ConvertField
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    @ConvertField
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    @ConvertField
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    private BigDecimal totalAfterCostAdjustTaxMny; // 工程造价调整后总金额
    private BigDecimal totalAfterCostAdjustMny; // 工程造价调整后总金额(无税)
    private BigDecimal totalAfterCostAdjustTax; // 工程造价调整后税额
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)

    private String progressPaymentClause; // 工程进度款支付条款
    private String projectAddress; // 工程地点

    private BigDecimal projectContractMny; // 合同金额（集团项目）
    private BigDecimal projectContractMnyWan; // 合同金额（集团项目）万元

    private Long constructionUnitsId; // 分类id
    private String constructionUnitsName; // 建设单位分类名称

//    private BigDecimal contractSettleRate; // 合同约定竣工结算支付比例
    private Integer isParentProject; // 是否父项目：1 是 2否

    private String contractRegisterName; // 上游合同项目名称
    private Integer constructionUnit; // 建设单位性质：1集团内/2集团外



    /**
     * 建设模式Id
     */
    private Long constructionModeId;
    /**
     * 建设模式名称
     */
    private String constructionModeName;

    /**
     * 是否联合体：0-否，1-是
     */
    private String comboFlag;

    /**
     * 联合体单位：（供应商Id）
     */
    private Long comboId;
    /**
     * 联合体单位编码（供应商编码）
     */
    private String comboCode;
    /**
     * 联合体单位名称（供应商名称）
     */
    private String comboName;

    /**
     * 项目经理
     */
    private String projectManagerName;

    private String contractRange; // 合同范围
    private String scheduleDefaultMny; // 工期违约金
    private String qualityRequire; // 质量要求
    private String executeProjectManager; // 执行项目经理
    private Long performanceMnyTypeId; // 履约保证金
    private String performanceMnyTypeName; // 履约保证金类型名称
    private String performanceMnyTypeRate; // 履约保证金-比例
    private BigDecimal advancePaymentRate; // 预付款比例（%）
    private String progressPaymentCondition; // 进度款支付条件
    private String defectResponseTime; // 缺陷责任期
    private BigDecimal retentionMnyRate; // 质保金比例（%）
    private BigDecimal contractSettleRate; //合同约定竣工结算支付比例
    private String settleCondition; //竣工结算支付条件


    public BigDecimal getContractSettleRate() {
        return contractSettleRate;
    }

    public void setContractSettleRate(BigDecimal contractSettleRate) {
        this.contractSettleRate = contractSettleRate;
    }

    public String getSettleCondition() {
        return settleCondition;
    }

    public void setSettleCondition(String settleCondition) {
        this.settleCondition = settleCondition;
    }

    public Integer getIsParentProject() {
        return isParentProject;
    }

    public void setIsParentProject(Integer isParentProject) {
        this.isParentProject = isParentProject;
    }

    public String getContractRegisterName() {
        return contractRegisterName;
    }

    public void setContractRegisterName(String contractRegisterName) {
        this.contractRegisterName = contractRegisterName;
    }

    public Integer getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Integer constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getConstructionModeId() {
        return constructionModeId;
    }

    @ReferDeserialTransfer
    public void setConstructionModeId(Long constructionModeId) {
        this.constructionModeId = constructionModeId;
    }

    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }

    public Date getContractStampDate() {
        return contractStampDate;
    }

    public void setContractStampDate(Date contractStampDate) {
        this.contractStampDate = contractStampDate;
    }

    public Integer getContractStampNum() {
        return contractStampNum;
    }

    public void setContractStampNum(Integer contractStampNum) {
        this.contractStampNum = contractStampNum;
    }

    public Integer getContractBack() {
        return contractBack;
    }

    public void setContractBack(Integer contractBack) {
        this.contractBack = contractBack;
    }

    public Date getContractBackDate() {
        return contractBackDate;
    }

    public void setContractBackDate(Date contractBackDate) {
        this.contractBackDate = contractBackDate;
    }

    public Integer getBackNum() {
        return backNum;
    }

    public void setBackNum(Integer backNum) {
        this.backNum = backNum;
    }

    public Integer getReportJt() {
        return reportJt;
    }

    public void setReportJt(Integer reportJt) {
        this.reportJt = reportJt;
    }

    public Date getReportJtDate() {
        return reportJtDate;
    }

    public void setReportJtDate(Date reportJtDate) {
        this.reportJtDate = reportJtDate;
    }

    public Integer getContractPresentation() {
        return contractPresentation;
    }

    public void setContractPresentation(Integer contractPresentation) {
        this.contractPresentation = contractPresentation;
    }

    public String getConstructionModeName() {
        return constructionModeName;
    }

    public void setConstructionModeName(String constructionModeName) {
        this.constructionModeName = constructionModeName;
    }

    public String getComboFlag() {
        return comboFlag;
    }

    public void setComboFlag(String comboFlag) {
        this.comboFlag = comboFlag;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getComboId() {
        return comboId;
    }

    @ReferDeserialTransfer
    public void setComboId(Long comboId) {
        this.comboId = comboId;
    }

    public String getComboCode() {
        return comboCode;
    }

    public void setComboCode(String comboCode) {
        this.comboCode = comboCode;
    }

    public String getComboName() {
        return comboName;
    }

    public void setComboName(String comboName) {
        this.comboName = comboName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProgressPaymentClause() {
        return progressPaymentClause;
    }

    public void setProgressPaymentClause(String progressPaymentClause) {
        this.progressPaymentClause = progressPaymentClause;
    }
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }
    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalAfterCostAdjustTaxMny() {
        return totalAfterCostAdjustTaxMny;
    }

    public void setTotalAfterCostAdjustTaxMny(BigDecimal totalAfterCostAdjustTaxMny) {
        this.totalAfterCostAdjustTaxMny = totalAfterCostAdjustTaxMny;
    }

    public BigDecimal getTotalAfterCostAdjustMny() {
        return totalAfterCostAdjustMny;
    }

    public void setTotalAfterCostAdjustMny(BigDecimal totalAfterCostAdjustMny) {
        this.totalAfterCostAdjustMny = totalAfterCostAdjustMny;
    }

    public BigDecimal getTotalAfterCostAdjustTax() {
        return totalAfterCostAdjustTax;
    }

    public void setTotalAfterCostAdjustTax(BigDecimal totalAfterCostAdjustTax) {
        this.totalAfterCostAdjustTax = totalAfterCostAdjustTax;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同评审
     */
    @ReferSerialTransfer(referCode="proincome-contract-review")
    public Long getReviewId() {
        return reviewId;
    }

    /**
     * 合同评审
     */
    @ReferDeserialTransfer
    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 承揽方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    @ReferDeserialTransfer
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同甲方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 合同乙方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同(签订)金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同(签订)金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同(签订)金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }
    /**
     * 合同计价形式，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    /**
     * 联体合同总金额
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总金额
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }
    
    /**
     * 工程造价及变动合计总金额(无税)
     */
    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    /**
     * 工程造价及变动合计总金额(无税)
     */
    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }
    /**
     * 工程造价及变动合计总金额
     */
    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    /**
     * 工程造价及变动合计总金额
     */
    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }
    /**
     * 暂列金额
     */
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    /**
     * 暂列金额
     */
    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    /**
     * 合同约定收款比例
     */
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    /**
     * 合同约定收款比例
     */
    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    /**
     * 初始版本税额
     */
    public BigDecimal getBaseTax() {
        return baseTax;
    }

    /**
     * 初始版本税额
     */
    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public String getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计甲方报量（含税）
     */
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 累计甲方报量
     */
    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计甲方报量
     */
    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计收款
     */
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    /**
     * 累计收款
     */
    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    /**
     * 累计开票（含税）
     */
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计开票（含税）
     */
    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计开票
     */
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计开票
     */
    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    /**
     * 变更洽商总金额(无税)
     */
    public BigDecimal getSumNegotiateMny() {
        return sumNegotiateMny;
    }

    /**
     * 变更洽商总金额(无税)
     */
    public void setSumNegotiateMny(BigDecimal sumNegotiateMny) {
        this.sumNegotiateMny = sumNegotiateMny;
    }

    /**
     * 变更洽商总金额
     */
    public BigDecimal getSumNegotiateTaxMny() {
        return sumNegotiateTaxMny;
    }

    /**
     * 变更洽商总金额
     */
    public void setSumNegotiateTaxMny(BigDecimal sumNegotiateTaxMny) {
        this.sumNegotiateTaxMny = sumNegotiateTaxMny;
    }

    /**
     * 经济签证总金额(无税)
     */
    public BigDecimal getSumVisaMny() {
        return sumVisaMny;
    }

    /**
     * 经济签证总金额(无税)
     */
    public void setSumVisaMny(BigDecimal sumVisaMny) {
        this.sumVisaMny = sumVisaMny;
    }

    /**
     * 经济签证总金额
     */
    public BigDecimal getSumVisaTaxMny() {
        return sumVisaTaxMny;
    }

    /**
     * 经济签证总金额
     */
    public void setSumVisaTaxMny(BigDecimal sumVisaTaxMny) {
        this.sumVisaTaxMny = sumVisaTaxMny;
    }

    /**
     * 索赔总金额(无税)
     */
    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    /**
     * 索赔总金额(无税)
     */
    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    /**
     * 索赔总金额
     */
    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    /**
     * 索赔总金额
     */
    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    /**
     * 累计变更洽商金额(无税)
     */
    public BigDecimal getSumOperateMny() {
        return sumOperateMny;
    }

    /**
     * 累计变更洽商金额(无税)
     */
    public void setSumOperateMny(BigDecimal sumOperateMny) {
        this.sumOperateMny = sumOperateMny;
    }

    /**
     * 累计变更洽商金额
     */
    public BigDecimal getSumOperateTaxMny() {
        return sumOperateTaxMny;
    }

    /**
     * 累计变更洽商金额
     */
    public void setSumOperateTaxMny(BigDecimal sumOperateTaxMny) {
        this.sumOperateTaxMny = sumOperateTaxMny;
    }
    
    /**
     * 累计甲供材结算金额(无税)
     */
    public BigDecimal getSumMaterialSettleMny() {
        return sumMaterialSettleMny;
    }

    /**
     * 累计甲供材结算金额(无税)
     */
    public void setSumMaterialSettleMny(BigDecimal sumMaterialSettleMny) {
        this.sumMaterialSettleMny = sumMaterialSettleMny;
    }

    /**
     * 累计甲供材结算金额
     */
    public BigDecimal getSumMaterialSettleTaxMny() {
        return sumMaterialSettleTaxMny;
    }

    /**
     * 累计甲供材结算金额
     */
    public void setSumMaterialSettleTaxMny(BigDecimal sumMaterialSettleTaxMny) {
        this.sumMaterialSettleTaxMny = sumMaterialSettleTaxMny;
    }
    
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public Integer getIsFinish() {
        return isFinish;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    /**
     * 是否已解除：0-否，1-是
     */
    public Integer getIsRelieve() {
        return isRelieve;
    }

    /**
     * 是否已解除：0-否，1-是
     */
    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }
    
    /**
     * 乙方电话
     */
    public String getSupplierPhone() {
        return supplierPhone;
    }

    /**
     * 乙方电话
     */
    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    /**
     * 甲方电话
     */
    public String getCustomerPhone() {
        return customerPhone;
    }

    /**
     * 甲方电话
     */
    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    /**
     * 甲方委托代理人
     */
    public String getCustomerEntrustedAgent() {
        return customerEntrustedAgent;
    }

    /**
     * 甲方委托代理人
     */
    public void setCustomerEntrustedAgent(String customerEntrustedAgent) {
        this.customerEntrustedAgent = customerEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public String getSupplierEntrustedAgent() {
        return supplierEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public void setSupplierEntrustedAgent(String supplierEntrustedAgent) {
        this.supplierEntrustedAgent = supplierEntrustedAgent;
    }
    
    /**
     * 争议解决方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDisputeResolution() {
        return disputeResolution;
    }

    /**
     * 争议解决方式
     */
    @ReferDeserialTransfer
    public void setDisputeResolution(Long disputeResolution) {
        this.disputeResolution = disputeResolution;
    }
    /**
     * 争议解决机构
     */
    public String getDisputeResolutionAgency() {
        return disputeResolutionAgency;
    }

    /**
     * 争议解决机构
     */
    public void setDisputeResolutionAgency(String disputeResolutionAgency) {
        this.disputeResolutionAgency = disputeResolutionAgency;
    }

    /**
     * 施工合同评审版本号
     */
    public Integer getReviewVersion() {
        return reviewVersion;
    }

    /**
     * 施工合同评审版本号
     */
    public void setReviewVersion(Integer reviewVersion) {
        this.reviewVersion = reviewVersion;
    }

    /**
     * 合同状态名称
     */
    public String getContractStatusName() {
        return contractStatusName;
    }

    /**
     * 合同状态名称
     */
    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    /**
     * 单据状态名称
     */
    public String getBillStateName() {
        return billStateName;
    }

    /**
     * 单据状态名称
     */
    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 协议内容
     */
    public String getSupplementContent() {
        return supplementContent;
    }

    /**
     * 协议内容
     */
    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    /**
     * 承包模式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    /**
     * 承包模式
     */
    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getContractRange() {
        return contractRange;
    }

    public void setContractRange(String contractRange) {
        this.contractRange = contractRange;
    }

    public String getScheduleDefaultMny() {
        return scheduleDefaultMny;
    }

    public void setScheduleDefaultMny(String scheduleDefaultMny) {
        this.scheduleDefaultMny = scheduleDefaultMny;
    }

    public String getQualityRequire() {
        return qualityRequire;
    }

    public void setQualityRequire(String qualityRequire) {
        this.qualityRequire = qualityRequire;
    }

    public String getExecuteProjectManager() {
        return executeProjectManager;
    }

    public void setExecuteProjectManager(String executeProjectManager) {
        this.executeProjectManager = executeProjectManager;
    }

    @ReferSerialTransfer(referCode = "income-performance-type")
    public Long getPerformanceMnyTypeId() {
        return performanceMnyTypeId;
    }

    @ReferDeserialTransfer
    public void setPerformanceMnyTypeId(Long performanceMnyTypeId) {
        this.performanceMnyTypeId = performanceMnyTypeId;
    }

    public String getPerformanceMnyTypeName() {
        return performanceMnyTypeName;
    }

    public void setPerformanceMnyTypeName(String performanceMnyTypeName) {
        this.performanceMnyTypeName = performanceMnyTypeName;
    }

    public String getPerformanceMnyTypeRate() {
        return performanceMnyTypeRate;
    }

    public void setPerformanceMnyTypeRate(String performanceMnyTypeRate) {
        this.performanceMnyTypeRate = performanceMnyTypeRate;
    }

    public BigDecimal getAdvancePaymentRate() {
        return advancePaymentRate;
    }

    public void setAdvancePaymentRate(BigDecimal advancePaymentRate) {
        this.advancePaymentRate = advancePaymentRate;
    }

    public String getProgressPaymentCondition() {
        return progressPaymentCondition;
    }

    public void setProgressPaymentCondition(String progressPaymentCondition) {
        this.progressPaymentCondition = progressPaymentCondition;
    }

    public String getDefectResponseTime() {
        return defectResponseTime;
    }

    public void setDefectResponseTime(String defectResponseTime) {
        this.defectResponseTime = defectResponseTime;
    }

    public BigDecimal getRetentionMnyRate() {
        return retentionMnyRate;
    }

    public void setRetentionMnyRate(BigDecimal retentionMnyRate) {
        this.retentionMnyRate = retentionMnyRate;
    }

    public BigDecimal getProjectContractMny() {
        return projectContractMny;
    }

    public void setProjectContractMny(BigDecimal projectContractMny) {
        this.projectContractMny = projectContractMny;
    }

    public BigDecimal getProjectContractMnyWan() {
        return projectContractMnyWan;
    }

    public void setProjectContractMnyWan(BigDecimal projectContractMnyWan) {
        this.projectContractMnyWan = projectContractMnyWan;
    }
    @ReferSerialTransfer(referCode = "construction-units")
    public Long getConstructionUnitsId() {
        return constructionUnitsId;
    }
    @ReferDeserialTransfer
    public void setConstructionUnitsId(Long constructionUnitsId) {
        this.constructionUnitsId = constructionUnitsId;
    }

    public String getConstructionUnitsName() {
        return constructionUnitsName;
    }

    public void setConstructionUnitsName(String constructionUnitsName) {
        this.constructionUnitsName = constructionUnitsName;
    }
}
