package com.ejianc.business.pro.income.vo;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目竣工未结推进表
 * 
 * @author generator
 * 
 */
public class UnsettleListVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 基层单位id
    private String orgCode; // 基层单位编码
    private String orgName; // 基层单位名称
    private BigDecimal unsettleMny; // 截至目前竣工未结金额
    private BigDecimal finalizeBackMny; // 定案返回金额
    private BigDecimal disputedMny; // 争议金额
    private BigDecimal monthDisputedMny; // 本月已解决争议金额
    private Integer monthDisputedNum; // 本月核销争议个数
    private BigDecimal sumDisputedMny; // 累计已解决争议金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String memo; // 备注

    private Long unsettleId; // 主表主键id
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long parentProjectId; // 所属父级项目id
    private String parentProjectCode; // 所属父级项目编码
    private String parentProjectName; // 所属父级项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate; // 竣工日期
    private String projectManager; // 项目经理
    private Long settleEmployeeId; // 结算负责人id
    private String settleEmployeeName; // 结算负责人名称
    private BigDecimal contractMny; // 合同金额
    private BigDecimal sumCompleteMny; // 累计实际完成产值
    private BigDecimal sumIncomeMny; // 累计收款金额
    private BigDecimal contractProgressScale; // 合同约定进度款支付比例
    private BigDecimal contractSettleScale; // 合同约定竣工结算支付比例
    private BigDecimal detailSubmitMny; // 送审金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailSubmitDate; // 预计送审日期
    private Integer finalizeType; // 定案阶段 1-一审、2-二审、3-三审、4-终审
    private Integer finalizeFlag; // 定案返回状态 0-已返回 1-未返回
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalizeDate; // 定案返回日期
    private BigDecimal finalizeMny; // 定案表返回金额
    private String disputedMemo; // 争议事项
    private BigDecimal detailDisputedMny; // 争议金额

    private Integer settleStage; // 结算阶段 1-第一阶段、2-第二阶段、3-第三阶段、4-第四阶段、5-第五阶段
    private String settleStageName;  //结算阶段名称
    private Integer submissionFlag; // 送审状态 0未送审、1已送审
    private String submissionFlagName;  //送审状态名称
    private Integer indexGrade; // 指标等级 1一类、2二类
    private String indexGradeName; // 指标等级名称
    private Integer scheduleCompletionDate; // 计划完成日期 1-第一季度、2-第二季度、3-第三季度、4-第四季度
    private String scheduleCompletionDateName; // 计划完成日期名称

    private List<UnsettleDetailVO> unsettleDetailList = new ArrayList<>(); // 竣工未结明细

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return unsettleId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getSubmissionFlagName() {
        return submissionFlagName;
    }

    public void setSubmissionFlagName(String submissionFlagName) {
        this.submissionFlagName = submissionFlagName;
    }

    public String getIndexGradeName() {
        return indexGradeName;
    }

    public void setIndexGradeName(String indexGradeName) {
        this.indexGradeName = indexGradeName;
    }

    public String getScheduleCompletionDateName() {
        return scheduleCompletionDateName;
    }

    public void setScheduleCompletionDateName(String scheduleCompletionDateName) {
        this.scheduleCompletionDateName = scheduleCompletionDateName;
    }

    public String getSettleStageName() {
        return settleStageName;
    }

    public void setSettleStageName(String settleStageName) {
        this.settleStageName = settleStageName;
    }

    public Integer getSubmissionFlag() {
        return submissionFlag;
    }

    public void setSubmissionFlag(Integer submissionFlag) {
        this.submissionFlag = submissionFlag;
    }

    public Integer getIndexGrade() {
        return indexGrade;
    }

    public void setIndexGrade(Integer indexGrade) {
        this.indexGrade = indexGrade;
    }

    public Integer getScheduleCompletionDate() {
        return scheduleCompletionDate;
    }

    public void setScheduleCompletionDate(Integer scheduleCompletionDate) {
        this.scheduleCompletionDate = scheduleCompletionDate;
    }

    public Integer getSettleStage() {
        return settleStage;
    }

    public void setSettleStage(Integer settleStage) {
        this.settleStage = settleStage;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    public BigDecimal getFinalizeBackMny() {
        return finalizeBackMny;
    }

    public void setFinalizeBackMny(BigDecimal finalizeBackMny) {
        this.finalizeBackMny = finalizeBackMny;
    }

    public Long getUnsettleId() {
        return unsettleId;
    }

    public void setUnsettleId(Long unsettleId) {
        this.unsettleId = unsettleId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getParentProjectId() {
        return parentProjectId;
    }

    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }

    public String getParentProjectCode() {
        return parentProjectCode;
    }

    public void setParentProjectCode(String parentProjectCode) {
        this.parentProjectCode = parentProjectCode;
    }

    public String getParentProjectName() {
        return parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }

    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }

    public Long getSettleEmployeeId() {
        return settleEmployeeId;
    }

    public void setSettleEmployeeId(Long settleEmployeeId) {
        this.settleEmployeeId = settleEmployeeId;
    }

    public String getSettleEmployeeName() {
        return settleEmployeeName;
    }

    public void setSettleEmployeeName(String settleEmployeeName) {
        this.settleEmployeeName = settleEmployeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumCompleteMny() {
        return sumCompleteMny;
    }

    public void setSumCompleteMny(BigDecimal sumCompleteMny) {
        this.sumCompleteMny = sumCompleteMny;
    }

    public BigDecimal getSumIncomeMny() {
        return sumIncomeMny;
    }

    public void setSumIncomeMny(BigDecimal sumIncomeMny) {
        this.sumIncomeMny = sumIncomeMny;
    }

    public BigDecimal getContractProgressScale() {
        return contractProgressScale;
    }

    public void setContractProgressScale(BigDecimal contractProgressScale) {
        this.contractProgressScale = contractProgressScale;
    }

    public BigDecimal getContractSettleScale() {
        return contractSettleScale;
    }

    public void setContractSettleScale(BigDecimal contractSettleScale) {
        this.contractSettleScale = contractSettleScale;
    }

    public BigDecimal getDetailSubmitMny() {
        return detailSubmitMny;
    }

    public void setDetailSubmitMny(BigDecimal detailSubmitMny) {
        this.detailSubmitMny = detailSubmitMny;
    }

    public Date getDetailSubmitDate() {
        return detailSubmitDate;
    }

    public void setDetailSubmitDate(Date detailSubmitDate) {
        this.detailSubmitDate = detailSubmitDate;
    }

    public Integer getFinalizeType() {
        return finalizeType;
    }

    public void setFinalizeType(Integer finalizeType) {
        this.finalizeType = finalizeType;
    }

    public Integer getFinalizeFlag() {
        return finalizeFlag;
    }

    public void setFinalizeFlag(Integer finalizeFlag) {
        this.finalizeFlag = finalizeFlag;
    }

    public Date getFinalizeDate() {
        return finalizeDate;
    }

    public void setFinalizeDate(Date finalizeDate) {
        this.finalizeDate = finalizeDate;
    }

    public String getDisputedMemo() {
        return disputedMemo;
    }

    public void setDisputedMemo(String disputedMemo) {
        this.disputedMemo = disputedMemo;
    }

    public BigDecimal getDetailDisputedMny() {
        return detailDisputedMny;
    }

    public void setDetailDisputedMny(BigDecimal detailDisputedMny) {
        this.detailDisputedMny = detailDisputedMny;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getUnsettleMny() {
        return unsettleMny;
    }

    public void setUnsettleMny(BigDecimal unsettleMny) {
        this.unsettleMny = unsettleMny;
    }
    public BigDecimal getFinalizeMny() {
        return finalizeMny;
    }

    public void setFinalizeMny(BigDecimal finalizeMny) {
        this.finalizeMny = finalizeMny;
    }
    public BigDecimal getDisputedMny() {
        return disputedMny;
    }

    public void setDisputedMny(BigDecimal disputedMny) {
        this.disputedMny = disputedMny;
    }
    public BigDecimal getMonthDisputedMny() {
        return monthDisputedMny;
    }

    public void setMonthDisputedMny(BigDecimal monthDisputedMny) {
        this.monthDisputedMny = monthDisputedMny;
    }
    public Integer getMonthDisputedNum() {
        return monthDisputedNum;
    }

    public void setMonthDisputedNum(Integer monthDisputedNum) {
        this.monthDisputedNum = monthDisputedNum;
    }
    public BigDecimal getSumDisputedMny() {
        return sumDisputedMny;
    }

    public void setSumDisputedMny(BigDecimal sumDisputedMny) {
        this.sumDisputedMny = sumDisputedMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<UnsettleDetailVO> getUnsettleDetailList() {
        return unsettleDetailList;
     }

     public void setUnsettleDetailList(List<UnsettleDetailVO> unsettleDetailList) {
        this.unsettleDetailList = unsettleDetailList;
     }
}
