package com.ejianc.business.pro.income.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 预算分类
 * 
 * @author generator
 * 
 */
public class BudgetCategoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 编号
    private String name; // 名称
    private Integer incomeFlag; // 是否收入(1:是，0：否)
    private String memo; // 备注
    private Long orgId; // 组织
    private String orgCode; // 组织编号
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编号
    private String parentOrgName; // 父级组织名称
    private String incomeFlagName; //是否收入
    

    /**
     * 编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 是否收入(1:是，0：否)
     */
    public Integer getIncomeFlag() {
        return incomeFlag;
    }

    /**
     * 是否收入(1:是，0：否)
     */
    public void setIncomeFlag(Integer incomeFlag) {
        this.incomeFlag = incomeFlag;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getIncomeFlagName() {
        return incomeFlagName;
    }

    public void setIncomeFlagName(String incomeFlagName) {
        this.incomeFlagName = incomeFlagName;
    }
}
