package com.ejianc.business.pro.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 施工合同评审
 * 
 * @author generator
 * 
 */
public class ContractReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String contractName; // 工程名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额
    private Long customerId; // 合同甲方
    private String customerName; // 合同甲方名称
    private Long supplierId; // 合同乙方
    private String supplierName; // 合同乙方名称
    private String constructionPartner; // 施工联合方
    private BigDecimal taxRate; // 合同税率
    private BigDecimal taxMny; // 税额
    private Long contractType; // 合同类型
    private Long contractValuationType; // 合同计价形式，档案
    private BigDecimal builtArea; // 建筑面积(㎡)
    private String contractPartyc; // 合同丙方
    private BigDecimal conjoinedContractTotalMny; // 联体合同总造价
    private Long architectId; // 建造师
    private String architectName; // 建造师名称
    private Long managerId; // 项目责任人
    private String managerName; // 项目责任人名称
    private Long engineeringTypeId; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private String address; // 项目地址
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String briefDescription; // 补充协议简要说明
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private String contractScope; // 承包范围
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    private Integer schedule; // 工期
    private String qualityRequirement; // 质量要求
    private String safetyGoal; // 安全目标
    private String civilizationConstructionGoal; // 文明施工目标
    private Integer advancePayment; // 预付款：0-无，1-有
    private Integer progressPayment; // 工程进度款支付：0-按节点支付，1-按月支付
    private String nodePayment; // 按节点支付
    private String monthPayment; // 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
    private String qualityDeposit; // 质量保证金：0-3%，1-5%
    private String priceAdjustment; // 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
    private String priceAdjustmentDetail; // 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    private String breach; // 违约

    
    private String advancePaymentInfo; // 预付款信息
    private String priceAdjustmentSecond; // 价格调整2：0-采用造价信息进行价格调整，1-采用价格指数进行价格调整，2-专用合同条款约定的其他方式
    private String priceAdjustmentThird; // 价格调整3：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    private String priceAdjustmentInfo; // 法律变化引起的调整信息
    private String priceAdjustmentThirdTwo; // 采用价格指数进行价格调整信息
    private String priceAdjustmentThirdThree; // 专用合同条款约定的其他方式信息
    private String otherTerms; // 其它条款
    private String billStateName; // 单据状态名称
    private Long contractualModel; // 承包模式
    private Long bearType; // 承揽方式

    private Long fundsSourceId; // 资金来源(自定义档案)
    private Long constructId;//建设单位
    private String constructName;//建设单位
    private String priceAdjustmentThirdOne; // 采用价格信息进行价格调整信息
    private String paymentTerm; //支付条款描述
    private BigDecimal fixedPaymentRate; //固定付款比例
    private Integer contractLimitType; // 合同类别(设计合同-0,省内3000万以下-1,省内3000万以上-2,省外3000万以下-3,省外3000万以上-4)
    private Long contractProtocolId; // 拟定合同方
    private String contractProtocolName; // 拟定合同方名称
    private Long tenderType; // 招标方式
    private BigDecimal tenderTaxMny; // 中标价(含税)
    private Integer diffReason; // 中标价与合同价不一致原因(0-投标条件承诺, 1-报价时自行承诺,2-合同草案洽谈承诺)
    private String idea; // 合同起草单位意见
    private Integer reviewType; // 评审形式(0-会签评审,1-会议评审)
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private String reviewFilePath; // 会议评审附件路径
    private Long reviewFileId; // 会议评审附件id

    private List<ContractReviewClauseVO> contractReviewClauseList = new ArrayList<>(); // 施工合同评审-合同条件
    private List<ContractReviewRequireVO> contractReviewRequireList = new ArrayList<>(); // 施工合同评审-甲方相关要求

    public Integer getContractLimitType() {
        return contractLimitType;
    }

    public void setContractLimitType(Integer contractLimitType) {
        this.contractLimitType = contractLimitType;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractProtocolId() {
        return contractProtocolId;
    }
    @ReferDeserialTransfer
    public void setContractProtocolId(Long contractProtocolId) {
        this.contractProtocolId = contractProtocolId;
    }

    public String getContractProtocolName() {
        return contractProtocolName;
    }

    public void setContractProtocolName(String contractProtocolName) {
        this.contractProtocolName = contractProtocolName;
    }
    @ReferSerialTransfer(referCode = "proincome-tender-type")
    public Long getTenderType() {
        return tenderType;
    }
    @ReferDeserialTransfer
    public void setTenderType(Long tenderType) {
        this.tenderType = tenderType;
    }

    public BigDecimal getTenderTaxMny() {
        return tenderTaxMny;
    }

    public void setTenderTaxMny(BigDecimal tenderTaxMny) {
        this.tenderTaxMny = tenderTaxMny;
    }

    public Integer getDiffReason() {
        return diffReason;
    }

    public void setDiffReason(Integer diffReason) {
        this.diffReason = diffReason;
    }

    public String getIdea() {
        return idea;
    }

    public void setIdea(String idea) {
        this.idea = idea;
    }

    public Integer getReviewType() {
        return reviewType;
    }

    public void setReviewType(Integer reviewType) {
        this.reviewType = reviewType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getReviewFilePath() {
        return reviewFilePath;
    }

    public void setReviewFilePath(String reviewFilePath) {
        this.reviewFilePath = reviewFilePath;
    }

    public Long getReviewFileId() {
        return reviewFileId;
    }

    public void setReviewFileId(Long reviewFileId) {
        this.reviewFileId = reviewFileId;
    }

    public List<ContractReviewClauseVO> getContractReviewClauseList() {
        return contractReviewClauseList;
    }

    public void setContractReviewClauseList(List<ContractReviewClauseVO> contractReviewClauseList) {
        this.contractReviewClauseList = contractReviewClauseList;
    }

    public List<ContractReviewRequireVO> getContractReviewRequireList() {
        return contractReviewRequireList;
    }

    public void setContractReviewRequireList(List<ContractReviewRequireVO> contractReviewRequireList) {
        this.contractReviewRequireList = contractReviewRequireList;
    }

    private List<ContractReviewVO> children;

    public String getPriceAdjustmentThirdOne() {
        return priceAdjustmentThirdOne;
    }

    public void setPriceAdjustmentThirdOne(String priceAdjustmentThirdOne) {
        this.priceAdjustmentThirdOne = priceAdjustmentThirdOne;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getFixedPaymentRate() {
        return fixedPaymentRate;
    }

    public void setFixedPaymentRate(BigDecimal fixedPaymentRate) {
        this.fixedPaymentRate = fixedPaymentRate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 工程名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同甲方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 合同乙方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    
    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    
    /**
     * 合同计价形式，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 建筑面积(㎡)
     */
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积(㎡)
     */
    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }
    /**
     * 联体合同总造价
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总造价
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }
    /**
     * 建造师
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getArchitectId() {
        return architectId;
    }

    /**
     * 建造师
     */
    @ReferDeserialTransfer
    public void setArchitectId(Long architectId) {
        this.architectId = architectId;
    }
    /**
     * 建造师名称
     */
    public String getArchitectName() {
        return architectName;
    }

    /**
     * 建造师名称
     */
    public void setArchitectName(String architectName) {
        this.architectName = architectName;
    }
    /**
     * 项目责任人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 项目责任人
     */
    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    
    /**
     * 项目责任人名称
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 项目责任人名称
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 工程类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类型
     */
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 项目地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 项目地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 补充协议简要说明
     */
    public String getBriefDescription() {
        return briefDescription;
    }

    /**
     * 补充协议简要说明
     */
    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }
    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }
    /**
     * 质量要求
     */
    public String getQualityRequirement() {
        return qualityRequirement;
    }

    /**
     * 质量要求
     */
    public void setQualityRequirement(String qualityRequirement) {
        this.qualityRequirement = qualityRequirement;
    }
    /**
     * 安全目标
     */
    public String getSafetyGoal() {
        return safetyGoal;
    }

    /**
     * 安全目标
     */
    public void setSafetyGoal(String safetyGoal) {
        this.safetyGoal = safetyGoal;
    }
    /**
     * 文明施工目标
     */
    public String getCivilizationConstructionGoal() {
        return civilizationConstructionGoal;
    }

    /**
     * 文明施工目标
     */
    public void setCivilizationConstructionGoal(String civilizationConstructionGoal) {
        this.civilizationConstructionGoal = civilizationConstructionGoal;
    }
    /**
     * 预付款：0-无，1-有
     */
    public Integer getAdvancePayment() {
        return advancePayment;
    }

    /**
     * 预付款：0-无，1-有
     */
    public void setAdvancePayment(Integer advancePayment) {
        this.advancePayment = advancePayment;
    }
    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public Integer getProgressPayment() {
        return progressPayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public void setProgressPayment(Integer progressPayment) {
        this.progressPayment = progressPayment;
    }
    /**
     * 按节点支付
     */
    public String getNodePayment() {
        return nodePayment;
    }

    /**
     * 按节点支付
     */
    public void setNodePayment(String nodePayment) {
        this.nodePayment = nodePayment;
    }
    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public String getMonthPayment() {
        return monthPayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public void setMonthPayment(String monthPayment) {
        this.monthPayment = monthPayment;
    }
    /**
     * 质量保证金：0-3%，1-5%
     */
    public String getQualityDeposit() {
        return qualityDeposit;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public void setQualityDeposit(String qualityDeposit) {
        this.qualityDeposit = qualityDeposit;
    }
    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public String getPriceAdjustment() {
        return priceAdjustment;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public void setPriceAdjustment(String priceAdjustment) {
        this.priceAdjustment = priceAdjustment;
    }
    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public String getPriceAdjustmentDetail() {
        return priceAdjustmentDetail;
    }

    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public void setPriceAdjustmentDetail(String priceAdjustmentDetail) {
        this.priceAdjustmentDetail = priceAdjustmentDetail;
    }
    /**
     * 违约
     */
    public String getBreach() {
        return breach;
    }

    /**
     * 违约
     */
    public void setBreach(String breach) {
        this.breach = breach;
    }

    public String getAdvancePaymentInfo() {
        return advancePaymentInfo;
    }

    public void setAdvancePaymentInfo(String advancePaymentInfo) {
        this.advancePaymentInfo = advancePaymentInfo;
    }

    public String getPriceAdjustmentSecond() {
        return priceAdjustmentSecond;
    }

    public void setPriceAdjustmentSecond(String priceAdjustmentSecond) {
        this.priceAdjustmentSecond = priceAdjustmentSecond;
    }

    public String getPriceAdjustmentThird() {
        return priceAdjustmentThird;
    }

    public void setPriceAdjustmentThird(String priceAdjustmentThird) {
        this.priceAdjustmentThird = priceAdjustmentThird;
    }

    public String getPriceAdjustmentInfo() {
        return priceAdjustmentInfo;
    }

    public void setPriceAdjustmentInfo(String priceAdjustmentInfo) {
        this.priceAdjustmentInfo = priceAdjustmentInfo;
    }

    public String getPriceAdjustmentThirdTwo() {
        return priceAdjustmentThirdTwo;
    }

    public void setPriceAdjustmentThirdTwo(String priceAdjustmentThirdTwo) {
        this.priceAdjustmentThirdTwo = priceAdjustmentThirdTwo;
    }

    public String getPriceAdjustmentThirdThree() {
        return priceAdjustmentThirdThree;
    }

    public void setPriceAdjustmentThirdThree(String priceAdjustmentThirdThree) {
        this.priceAdjustmentThirdThree = priceAdjustmentThirdThree;
    }

    public String getOtherTerms() {
        return otherTerms;
    }

    public void setOtherTerms(String otherTerms) {
        this.otherTerms = otherTerms;
    }

    /**
     * 单据状态名称
     */
    public String getBillStateName() {
        return billStateName;
    }

    /**
     * 单据状态名称
     */
    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ContractReviewVO> getChildren() {
        return children;
    }

    public void setChildren(List<ContractReviewVO> children) {
        this.children = children;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    /**
     * 承揽方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    @ReferDeserialTransfer
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    @ReferDeserialTransfer
    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
}
