package com.ejianc.business.pro.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/3/3 16:16
 */
public enum UseStatusEnum {
    //在用状态 1：资审在用；2：招标文件评审中；3：投标在用；4：中标在用；5：其他在用；
    资审在用("资审在用", "1"),
    招标文件评审中("招标文件评审中", "2"),
    投标在用("投标在用", "3"),
    中标在用("中标在用", "4"),
    其他在用("其他在用", "5");

    UseStatusEnum(String statusName, String status) {
        this.statusName = statusName;
        this.status = status;
    }
    private static Map<String, UseStatusEnum> enumMap = new HashMap<>();

    private String statusName;
    private String status;

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    static {
        enumMap = EnumSet.allOf(UseStatusEnum.class).stream().collect(Collectors.toMap(UseStatusEnum::getStatus, Function.identity(), (k1, k2) -> k2));
    }


    public static UseStatusEnum getEnumByStatus(String billStateCode) {
        return enumMap.get(billStateCode);
    }

}
