package com.ejianc.business.pro.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 工程定案
 * 
 * @author generator
 * 
 */
public class FinalizedHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private String changeStatus;

    /**
     * 是否已做终审(1:是，0：否)
     */
    private Integer isFinish;

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;

    /**
     * 审定总金额
     */
    private BigDecimal sumCheckMny; 

    /**
     * 审减总金额
     */
    private BigDecimal sumReviewSubtractMny;
    private Integer isSuspend; // 是否已中止/解除：0-否，1-是


    private List<FinalizedVO> detailList = new ArrayList<>();
    
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public BigDecimal getSumCheckMny() {
        return sumCheckMny;
    }

    public void setSumCheckMny(BigDecimal sumCheckMny) {
        this.sumCheckMny = sumCheckMny;
    }

    public BigDecimal getSumReviewSubtractMny() {
        return sumReviewSubtractMny;
    }

    public void setSumReviewSubtractMny(BigDecimal sumReviewSubtractMny) {
        this.sumReviewSubtractMny = sumReviewSubtractMny;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public List<FinalizedVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<FinalizedVO> detailList) {
        this.detailList = detailList;
    }
}
