package com.ejianc.business.pro.income.api;

import com.ejianc.business.pro.income.hystrix.ProincomeContrantHystrix;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Map;

@FeignClient(name= "ejc-proincome-web", url="${common.env.feign-client-url}", path="ejc-proincome-web", fallback = ProincomeContrantHystrix.class)
public interface IProincomeContractApi {
    /**
     * 根据项目ID(projectID)查询该项目最新生效的施工合同
     * @param projectId
     * @return
     */
    @GetMapping("/api/proincomeContrantApi/queryContranct")
    public CommonResponse<BigDecimal> queryContranct(@RequestParam(value = "projectId") Long projectId);

    /**
     * 根据项目部组织ID(orgId)查询该项目部下已生效的产值金额(含税)汇总
     * @param orgId
     * @return
     */
    @GetMapping("/api/proincomeContrantApi/queryProduction")
    public CommonResponse<BigDecimal> queryProduction(@RequestParam(value = "orgId", required = false) Long orgId);

    /**
     * 查询已生效的产值金额(含税)汇总
     * @return
     */
    @GetMapping("/api/proincomeContrantApi/queryTotalProduction")
    public CommonResponse<Map<Long,ProductionVO>> queryTotalProduction();

    /**
     * 根据项目ID(projectID)查询该项目最新生效的施工合同
     * @return
     */
    @GetMapping("/api/proincomeContrantApi/queryContranctMny")
    public CommonResponse<ContractRegisterVO> queryContranctMny(@RequestParam(value = "projectId") Long projectId);

    /**
     * 根据项目ID查询该项目部下已生效的产值金额(含税)汇总
     * @param projectId
     * @return
     */
    @GetMapping("/api/proincomeContrantApi/queryProductionByProject")
    public CommonResponse<BigDecimal> queryProductionByProject(@RequestParam(value = "projectId") Long projectId);

    @PostMapping("/api/proincomeContrantApi/updateRegistrationUseFlag")
    public CommonResponse<String> updateRegistrationUseFlag(@RequestBody ClaimVO claimVO);
}
