package com.ejianc.business.pro.other.history;

import com.ejianc.business.pro.other.vo.OtherSettleVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class OtherSettleHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;

    private Integer isFinish; // 是否已做结算(1:是，0：否)

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;

    /**
     * 是否已冻结：0-否，1-是
     */
    private Integer isSuspend;


    private Integer settleFlag;
    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;
    /**
     * 累计甲方报量（含税）
     */
    private BigDecimal totalSettleTaxMny;
    /**
     * 累计结算比例
     */
    private BigDecimal totalSettleRate;

    private BigDecimal settleTaxMny;

    private List<OtherSettleVO> settleRecord = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleRate() {
        return totalSettleRate;
    }

    public void setTotalSettleRate(BigDecimal totalSettleRate) {
        this.totalSettleRate = totalSettleRate;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public List<OtherSettleVO> getSettleRecord() {
        return settleRecord;
    }

    public void setSettleRecord(List<OtherSettleVO> settleRecord) {
        this.settleRecord = settleRecord;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }
}
