package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 措施项清单
 * 
 * @author generator
 * 
 */
public class BudgetMeasureVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private String detailIndex; // 序号
    private Long parentId; // 父ID
    private String measureCode; // 编码
    private String measureName; // 名称
    private String measureFeature; // 特征
    private String measureUnit; // 单位
    private BigDecimal measureNum; // 工程量
    private BigDecimal measureTaxRate; // 税率
    private BigDecimal measurePrice; // 综合单价(无税)
    private BigDecimal measureTaxPrice; // 综合单价(含税)
    private BigDecimal measureMny; // 合价(无税)
    private BigDecimal measureTaxMny; // 合价(含税)
    private BigDecimal measureTax; // 税额
    private String measureMemo; // 备注
    private Boolean leafFlag; // 是否末级
    private List<BudgetDetailVO> detailVos = new ArrayList<>(); // 清单明细

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private Long measureSubjectId; // 成本科目id
    private String measureSubjectName; // 成本科目名称

    private String measureCompositiveCoefficientName; //综合系数名称
    private Long measureCompositiveCoefficientId; //综合系数id
    private BigDecimal measureCompositiveCoefficient; //综合系数

    private String measureItemType; //清单类型  用于导入数据区分

    private List<ITreeNodeB> children;

    private Integer measurePriceType; //价税计算类型：0-无税优先， 1-含税优先

    //导入使用
    private Long budgetBid; // 清单项主键
    private BigDecimal detailContent; //明细含量
    private BigDecimal measureContent; //含量
    private int nodeLevel; //层级

    public BigDecimal getMeasureContent() {
        return measureContent;
    }

    public void setMeasureContent(BigDecimal measureContent) {
        this.measureContent = measureContent;
    }

    public Long getBudgetBid() {
        return budgetBid;
    }

    public void setBudgetBid(Long budgetBid) {
        this.budgetBid = budgetBid;
    }

    public BigDecimal getDetailContent() {
        return detailContent;
    }

    public void setDetailContent(BigDecimal detailContent) {
        this.detailContent = detailContent;
    }

    public int getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(int nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Integer getMeasurePriceType() {
        return measurePriceType;
    }

    public void setMeasurePriceType(Integer measurePriceType) {
        this.measurePriceType = measurePriceType;
    }

    public String getMeasureItemType() {
        return measureItemType;
    }

    public void setMeasureItemType(String measureItemType) {
        this.measureItemType = measureItemType;
    }

    public String getMeasureCompositiveCoefficientName() {
        return measureCompositiveCoefficientName;
    }

    public void setMeasureCompositiveCoefficientName(String measureCompositiveCoefficientName) {
        this.measureCompositiveCoefficientName = measureCompositiveCoefficientName;
    }

    @ReferSerialTransfer(referCode = "pro-income-coefficient")
    public Long getMeasureCompositiveCoefficientId() {
        return measureCompositiveCoefficientId;
    }

    @ReferDeserialTransfer
    public void setMeasureCompositiveCoefficientId(Long measureCompositiveCoefficientId) {
        this.measureCompositiveCoefficientId = measureCompositiveCoefficientId;
    }

    public BigDecimal getMeasureCompositiveCoefficient() {
        return measureCompositiveCoefficient;
    }

    public void setMeasureCompositiveCoefficient(BigDecimal measureCompositiveCoefficient) {
        this.measureCompositiveCoefficient = measureCompositiveCoefficient;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getMeasureSubjectId() {
        return measureSubjectId;
    }
    @ReferDeserialTransfer
    public void setMeasureSubjectId(Long measureSubjectId) {
        this.measureSubjectId = measureSubjectId;
    }

    public String getMeasureSubjectName() {
        return measureSubjectName;
    }

    public void setMeasureSubjectName(String measureSubjectName) {
        this.measureSubjectName = measureSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getMeasureTax() {
        return measureTax;
    }

    public void setMeasureTax(BigDecimal measureTax) {
        this.measureTax = measureTax;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public List<BudgetDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<BudgetDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getMeasureCode() {
        return measureCode;
    }

    /**
     * 编码
     */
    public void setMeasureCode(String measureCode) {
        this.measureCode = measureCode;
    }
    /**
     * 名称
     */
    public String getMeasureName() {
        return measureName;
    }

    /**
     * 名称
     */
    public void setMeasureName(String measureName) {
        this.measureName = measureName;
    }
    /**
     * 特征
     */
    public String getMeasureFeature() {
        return measureFeature;
    }

    /**
     * 特征
     */
    public void setMeasureFeature(String measureFeature) {
        this.measureFeature = measureFeature;
    }
    /**
     * 单位
     */
    public String getMeasureUnit() {
        return measureUnit;
    }

    /**
     * 单位
     */
    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }
    /**
     * 工程量
     */
    public BigDecimal getMeasureNum() {
        return measureNum;
    }

    /**
     * 工程量
     */
    public void setMeasureNum(BigDecimal measureNum) {
        this.measureNum = measureNum;
    }
    /**
     * 税率
     */
    public BigDecimal getMeasureTaxRate() {
        return measureTaxRate;
    }

    /**
     * 税率
     */
    public void setMeasureTaxRate(BigDecimal measureTaxRate) {
        this.measureTaxRate = measureTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public BigDecimal getMeasurePrice() {
        return measurePrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setMeasurePrice(BigDecimal measurePrice) {
        this.measurePrice = measurePrice;
    }
    /**
     * 综合单价(含税)
     */
    public BigDecimal getMeasureTaxPrice() {
        return measureTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setMeasureTaxPrice(BigDecimal measureTaxPrice) {
        this.measureTaxPrice = measureTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getMeasureMny() {
        return measureMny;
    }

    /**
     * 合价(无税)
     */
    public void setMeasureMny(BigDecimal measureMny) {
        this.measureMny = measureMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getMeasureTaxMny() {
        return measureTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setMeasureTaxMny(BigDecimal measureTaxMny) {
        this.measureTaxMny = measureTaxMny;
    }
    /**
     * 备注
     */
    public String getMeasureMemo() {
        return measureMemo;
    }

    /**
     * 备注
     */
    public void setMeasureMemo(String measureMemo) {
        this.measureMemo = measureMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"measurePrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"measureTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"measureNum"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"measureMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"measureTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"measureTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"measureTax"};
    }
}
