package com.ejianc.business.pro.other.history;

import com.ejianc.business.pro.income.vo.ContractSuspendVO;
import com.ejianc.business.pro.other.vo.OtherContractSuspendVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OtherContractSuspendHistoryVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long contractId;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private String changeStatus;

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    private Integer isFinish;

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;

    /**
     * 是否已中止：0-否，1-是
     */
    private Integer isSuspend;

    /**
     * 合同开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; 

    /**
     * 合同竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractEndDate;  
    
    private List<OtherContractSuspendVO> detailList = new ArrayList<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public Date getContractEndDate() {
        return contractEndDate;
    }

    public void setContractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public List<OtherContractSuspendVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OtherContractSuspendVO> detailList) {
        this.detailList = detailList;
    }
}
