package com.ejianc.business.pro.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ClaimRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;

    //变更洽商总金额(无税)
    private BigDecimal sumNegotiateMny;
    //变更洽商总金额
    private BigDecimal sumNegotiateTaxMny;

    //经济签证总金额(无税)
    private BigDecimal sumVisaMny;
    //经济签证总金额
    private BigDecimal sumVisaTaxMny;

    //索赔总金额(无税)
    private BigDecimal sumClaimMny;
    //索赔总金额
    private BigDecimal sumClaimTaxMny;

    //二次经营总金额(无税)
    private BigDecimal sumMny;
    //二次经营总金额
    private BigDecimal sumTaxMny;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private String changeStatus;

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    private Integer isFinish;

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;
    private Integer isSuspend; // 是否已中止/解除：0-否，1-是

    //变更签证索赔单据记录
    private List<ClaimVO> claimRecord = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getSumNegotiateMny() {
        return sumNegotiateMny;
    }

    public void setSumNegotiateMny(BigDecimal sumNegotiateMny) {
        this.sumNegotiateMny = sumNegotiateMny;
    }

    public BigDecimal getSumNegotiateTaxMny() {
        return sumNegotiateTaxMny;
    }

    public void setSumNegotiateTaxMny(BigDecimal sumNegotiateTaxMny) {
        this.sumNegotiateTaxMny = sumNegotiateTaxMny;
    }

    public BigDecimal getSumVisaMny() {
        return sumVisaMny;
    }

    public void setSumVisaMny(BigDecimal sumVisaMny) {
        this.sumVisaMny = sumVisaMny;
    }

    public BigDecimal getSumVisaTaxMny() {
        return sumVisaTaxMny;
    }

    public void setSumVisaTaxMny(BigDecimal sumVisaTaxMny) {
        this.sumVisaTaxMny = sumVisaTaxMny;
    }

    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }

    public BigDecimal getSumTaxMny() {
        return sumTaxMny;
    }

    public void setSumTaxMny(BigDecimal sumTaxMny) {
        this.sumTaxMny = sumTaxMny;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public List<ClaimVO> getClaimRecord() {
        return claimRecord;
    }

    public void setClaimRecord(List<ClaimVO> claimRecord) {
        this.claimRecord = claimRecord;
    }
}
