package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 结算报审
 * 
 * @author generator
 * 
 */
public class SettleReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编号
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编号
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    @ConvertField(targetField = "orgId")
    private Long orgId; // 组织
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 组织编码
    @ConvertField(targetField = "orgName")
    private String orgName; // 组织名称
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 父级组织
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 父级组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 父级组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 合同竣工日期
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    private BigDecimal contractTaxMny; // 合同(签订)金额
    private String contractValuationType; // 合同计价形式
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    private BigDecimal sumProductionMny; // 累计产值(无税)
    private BigDecimal sumProductionTaxMny; // 累计产值
    private BigDecimal sumCostMny; // 累计成本(无税)
    private BigDecimal sumCostTaxMny; // 累计成本
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    @ConvertField(targetField = "curMny")
    private BigDecimal reportSettleMny; // 报审结算金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField(targetField = "settleDate")
    private Date reportDate; // 报审日期
    private BigDecimal subtractTaxRate; // 合同约定审减率
    private BigDecimal predictCheckMny; // 预计审定金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date predictCheckDate; // 预计审定日期
    private BigDecimal materialMny; // 其中甲供材金额
    private String checkUnit; // 审核单位
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 经办部门
    @ConvertField(targetField = "departmentName")
    private String deptName; // 经办部门名称
    @ConvertField
    private String memo; // 备注
    @ConvertField
    private String billStateName; //单据状态名称
    private Integer contractVersion; //施工合同版本
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal reportSettleTaxMny; // 报审结算金额
    private BigDecimal taxRate; // 税率
    @ConvertField(targetField = "curTax")
    private BigDecimal tax; // 税额
    private String settleName; // 结算名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date realStartDate; // 实际开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date realEndDate; // 实际竣工日期
    private List<SettleReportDetailVO> unitProjectDetailList = new ArrayList<>(); // 单位工程明细
    private String reportSettleName; // 报审名称
    private String gdStatus;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gdDate;
    private String closeFlag;//是否已成本关门(1-是 2-否)
    private BigDecimal preTotalCost;//预计总成本
    private String reportProgress;//报审阶段
    private Long projectPartId;//执行标段id
    private String followRemark;//跟踪进展
    private BigDecimal totalReportSettleTaxMny;//累计报审结算金额



    public String getReportSettleName() {
        return reportSettleName;
    }

    public void setReportSettleName(String reportSettleName) {
        this.reportSettleName = reportSettleName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(String contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getPredictCheckMny() {
        return predictCheckMny;
    }

    public void setPredictCheckMny(BigDecimal predictCheckMny) {
        this.predictCheckMny = predictCheckMny;
    }
    public Date getPredictCheckDate() {
        return predictCheckDate;
    }

    public void setPredictCheckDate(Date predictCheckDate) {
        this.predictCheckDate = predictCheckDate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public List<SettleReportDetailVO> getUnitProjectDetailList() {
        return unitProjectDetailList;
     }

     public void setUnitProjectDetailList(List<SettleReportDetailVO> unitProjectDetailList) {
        this.unitProjectDetailList = unitProjectDetailList;
     }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    public Date getRealStartDate() {
        return realStartDate;
    }

    public void setRealStartDate(Date realStartDate) {
        this.realStartDate = realStartDate;
    }

    public Date getRealEndDate() {
        return realEndDate;
    }

    public void setRealEndDate(Date realEndDate) {
        this.realEndDate = realEndDate;
    }

    public String getGdStatus() {
        return gdStatus;
    }

    public void setGdStatus(String gdStatus) {
        this.gdStatus = gdStatus;
    }

    public Date getGdDate() {
        return gdDate;
    }

    public void setGdDate(Date gdDate) {
        this.gdDate = gdDate;
    }

    public String getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(String closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }

    public String getReportProgress() {
        return reportProgress;
    }

    public void setReportProgress(String reportProgress) {
        this.reportProgress = reportProgress;
    }
    @ReferSerialTransfer(referCode="pro-part")
    public Long getProjectPartId() {
        return projectPartId;
    }
    @ReferDeserialTransfer
    public void setProjectPartId(Long projectPartId) {
        this.projectPartId = projectPartId;
    }

    public String getFollowRemark() {
        return followRemark;
    }

    public void setFollowRemark(String followRemark) {
        this.followRemark = followRemark;
    }

    public BigDecimal getTotalReportSettleTaxMny() {
        return totalReportSettleTaxMny;
    }

    public void setTotalReportSettleTaxMny(BigDecimal totalReportSettleTaxMny) {
        this.totalReportSettleTaxMny = totalReportSettleTaxMny;
    }
}
