package com.ejianc.business.pro.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.vo.BudgetHistoryVO;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.income.bean.BudgetEntity;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目预算书
 *
 * @author generator
 *
 */
public interface IBudgetService extends IBaseService<BudgetEntity> {

    BudgetVO saveOrUpdate(BudgetVO saveorUpdateVO);

    BudgetVO queryDetail(Long id);

    BudgetVO saveBudget(BudgetVO saveorUpdateVO);

    void delete(List<BudgetVO> vos);

    CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response);

    CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response);

    BudgetVO queryBudgetDetail(Long id);

    void updateUseId(Long useId,String useType,List<Long> budgetIds);

    List<BudgetVO> selectByUseId(Long useId);

    void deleteUseId(List<Long> useId);

    BudgetHistoryVO queryBudgetHistory(Long id,Long accountingId);

    void relevanceBudget(Long useId, List<Long> ids, String useType);

    void deleteRelevanceBudget(List<Long> ids);

    CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response);

    List<BudgetReportVO> querySumBudgetMny(Long projectId,String beginPeriod, String endDate);

    List<BudgetReportVO> querySumBudgetMnyNew(Long projectId,String beginPeriod, String endDate);

    BigDecimal queryAllBudgetMny(Long projectId);

    CommonResponse<JSONObject> excelImportSX2JInProvinceInfo(HttpServletRequest request, HttpServletResponse response);

    String checkQuote(List<Long> compositiveCoefficientIds);
}
