/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.mapper.ClaimMapper;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="claimService")
public class ClaimServiceImpl
extends BaseServiceImpl<ClaimMapper, ClaimEntity>
implements IClaimService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Override
    public ClaimRecordVO queryRecordByContractId(Long contractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(contractId));
        ClaimRecordVO claimRecordVO = new ClaimRecordVO();
        claimRecordVO.setChangeStatus(entity.getChangeStatus());
        claimRecordVO.setIsFinish(entity.getIsFinish());
        claimRecordVO.setIsRelieve(entity.getIsRelieve());
        claimRecordVO.setIsSuspend(entity.getIsSuspend());
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(ClaimEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumNegotiateMny = BigDecimal.ZERO;
        BigDecimal sumNegotiateTaxMny = BigDecimal.ZERO;
        BigDecimal sumVisaMny = BigDecimal.ZERO;
        BigDecimal sumVisaTaxMny = BigDecimal.ZERO;
        BigDecimal sumClaimMny = BigDecimal.ZERO;
        BigDecimal sumClaimTaxMny = BigDecimal.ZERO;
        BigDecimal sumMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        List claimVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            claimVOS = BeanMapper.mapList((Iterable)list, ClaimVO.class);
            for (ClaimVO vo : claimVOS) {
                if ("QS".equals(vo.getBillType())) {
                    vo.setBillType("\u53d8\u66f4\u6d3d\u5546\u5355");
                    sumNegotiateMny = MathUtil.safeAdd(sumNegotiateMny, vo.getClaimMny());
                    sumNegotiateTaxMny = MathUtil.safeAdd(sumNegotiateTaxMny, vo.getClaimTaxMny());
                } else if ("QZ".equals(vo.getBillType())) {
                    vo.setBillType("\u7ecf\u6d4e\u7b7e\u8bc1\u5355");
                    sumVisaMny = MathUtil.safeAdd(sumVisaMny, vo.getClaimMny());
                    sumVisaTaxMny = MathUtil.safeAdd(sumVisaTaxMny, vo.getClaimTaxMny());
                } else if ("SP".equals(vo.getBillType())) {
                    vo.setBillType("\u7d22\u8d54\u5355");
                    sumClaimMny = MathUtil.safeAdd(sumClaimMny, vo.getClaimMny());
                    sumClaimTaxMny = MathUtil.safeAdd(sumClaimTaxMny, vo.getClaimTaxMny());
                }
                sumMny = MathUtil.safeAdd(sumMny, vo.getClaimMny());
                sumTaxMny = MathUtil.safeAdd(sumTaxMny, vo.getClaimTaxMny());
            }
        }
        claimRecordVO.setContractId(contractId);
        claimRecordVO.setSumNegotiateMny(sumNegotiateMny);
        claimRecordVO.setSumNegotiateTaxMny(sumNegotiateTaxMny);
        claimRecordVO.setSumVisaMny(sumVisaMny);
        claimRecordVO.setSumVisaTaxMny(sumVisaTaxMny);
        claimRecordVO.setSumClaimMny(sumClaimMny);
        claimRecordVO.setSumClaimTaxMny(sumClaimTaxMny);
        claimRecordVO.setSumMny(sumMny);
        claimRecordVO.setSumTaxMny(sumTaxMny);
        claimRecordVO.setClaimRecord(claimVOS);
        return claimRecordVO;
    }

    @Override
    public boolean updateContract(ClaimEntity claimEntity, Boolean flag) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ClaimEntity::getContractId, (Object)claimEntity.getContractId());
            queryWrapper.ne(BaseEntity::getId, (Object)claimEntity.getId());
            queryWrapper.in(ClaimEntity::getBillState, new Object[]{1, 3});
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            List list = this.claimService.list((Wrapper)queryWrapper);
            BigDecimal totalClaimTaxMny = BigDecimal.ZERO;
            BigDecimal totalClaimMny = BigDecimal.ZERO;
            BigDecimal totalClaimTax = BigDecimal.ZERO;
            BigDecimal totalReplyTaxMny = BigDecimal.ZERO;
            BigDecimal totalReplyMny = BigDecimal.ZERO;
            BigDecimal totalReplyTax = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                totalClaimTaxMny = list.stream().map(ClaimEntity::getClaimTaxMny).reduce(BigDecimal::add).get();
                totalClaimMny = list.stream().map(ClaimEntity::getClaimMny).reduce(BigDecimal::add).get();
                totalClaimTax = list.stream().map(ClaimEntity::getClaimTax).reduce(BigDecimal::add).get();
                List collect = list.stream().filter(e -> "1".equals(e.getReplyStatus())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    totalReplyTaxMny = collect.stream().map(ClaimEntity::getReplyTaxMny).reduce(BigDecimal::add).get();
                    totalReplyMny = collect.stream().map(ClaimEntity::getReplyMny).reduce(BigDecimal::add).get();
                    totalReplyTax = collect.stream().map(ClaimEntity::getReplyTax).reduce(BigDecimal::add).get();
                }
            }
            if (flag.booleanValue()) {
                totalClaimTaxMny = MathUtil.safeAdd(totalClaimTaxMny, claimEntity.getClaimTaxMny());
                totalClaimMny = MathUtil.safeAdd(totalClaimMny, claimEntity.getClaimMny());
                totalClaimTax = MathUtil.safeAdd(totalClaimTax, claimEntity.getClaimTax());
                if ("1".equals(claimEntity.getReplyStatus())) {
                    totalReplyTaxMny = MathUtil.safeAdd(totalReplyTaxMny, claimEntity.getReplyTaxMny());
                    totalReplyMny = MathUtil.safeAdd(totalReplyMny, claimEntity.getReplyMny());
                    totalReplyTax = MathUtil.safeAdd(totalReplyTax, claimEntity.getReplyTax());
                }
            }
            data.setId(claimEntity.getContractId());
            data.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
            data.setSourceId(claimEntity.getContractId());
            data.setTotalClaimTaxMny(totalClaimTaxMny);
            data.setTotalClaimMny(totalClaimMny);
            data.setTotalClaimTax(totalClaimTax);
            data.setTotalTeplyTaxMny(totalReplyTaxMny);
            data.setTotalTeplyMny(totalReplyMny);
            data.setTotalTeplyTax(totalReplyTax);
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u66f4\u65b0\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)claimEntity.getContractId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e2) {
            this.logger.error("\u5408\u540c-{}\u66f4\u65b0\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)claimEntity.getContractId(), (Object)e2);
        }
        return false;
    }

    @Override
    public Boolean updateCostAdjustId(Long costAdjustId, List<Long> claimIdsList) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ClaimEntity::getCostAdjustId, (Object)costAdjustId);
        updateWrapper.set(ClaimEntity::getCostAdjustId, null);
        this.update((Wrapper)updateWrapper);
        if (ListUtil.isNotEmpty(claimIdsList)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(BaseEntity::getId, claimIdsList);
            wrapper.set(ClaimEntity::getCostAdjustId, (Object)costAdjustId);
            this.update((Wrapper)wrapper);
        }
        return true;
    }
}

