package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 措施项清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_budget_measure")
public class BudgetMeasureEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="measure_code")
    private String measureCode; // 编码
    @TableField(value="measure_name")
    private String measureName; // 名称
    @TableField(value="measure_feature")
    private String measureFeature; // 特征
    @TableField(value="measure_unit")
    private String measureUnit; // 单位
    @TableField(value="measure_num")
    private java.math.BigDecimal measureNum; // 工程量
    @TableField(value="measure_tax_rate")
    private java.math.BigDecimal measureTaxRate; // 税率
    @TableField(value="measure_price")
    private java.math.BigDecimal measurePrice; // 综合单价(无税)
    @TableField(value="measure_tax_price")
    private java.math.BigDecimal measureTaxPrice; // 综合单价(含税)
    @TableField(value="measure_mny")
    private java.math.BigDecimal measureMny; // 合价(无税)
    @TableField(value="measure_tax_mny")
    private java.math.BigDecimal measureTaxMny; // 合价(含税)
    @TableField(value="measure_tax")
    private java.math.BigDecimal measureTax; // 合价(含税)
    @TableField(value="measure_memo")
    private String measureMemo; // 备注
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="measure_subject_id")
    private Long measureSubjectId; // 成本科目id
    @TableField(value="measure_subject_name")
    private String measureSubjectName; // 成本科目名称

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    @TableField(value = "measure_compositive_coefficient_name")
    private String measureCompositiveCoefficientName; //综合系数名称
    @TableField(value = "measure_compositive_coefficient_id")
    private Long measureCompositiveCoefficientId; //综合系数id
    @TableField(value = "measure_compositive_coefficient")
    private BigDecimal measureCompositiveCoefficient; //综合系数

    @TableField(value = "measure_item_type")
    private String measureItemType; //清单类型  用于导入数据区分

    @TableField(value = "measure_price_type")
    private Integer measurePriceType; //价税计算类型：0-无税优先， 1-含税优先

    public Integer getMeasurePriceType() {
        return measurePriceType;
    }

    public void setMeasurePriceType(Integer measurePriceType) {
        this.measurePriceType = measurePriceType;
    }

    public String getMeasureItemType() {
        return measureItemType;
    }

    public void setMeasureItemType(String measureItemType) {
        this.measureItemType = measureItemType;
    }

    public String getMeasureCompositiveCoefficientName() {
        return measureCompositiveCoefficientName;
    }

    public void setMeasureCompositiveCoefficientName(String measureCompositiveCoefficientName) {
        this.measureCompositiveCoefficientName = measureCompositiveCoefficientName;
    }

    public Long getMeasureCompositiveCoefficientId() {
        return measureCompositiveCoefficientId;
    }

    public void setMeasureCompositiveCoefficientId(Long measureCompositiveCoefficientId) {
        this.measureCompositiveCoefficientId = measureCompositiveCoefficientId;
    }

    public BigDecimal getMeasureCompositiveCoefficient() {
        return measureCompositiveCoefficient;
    }

    public void setMeasureCompositiveCoefficient(BigDecimal measureCompositiveCoefficient) {
        this.measureCompositiveCoefficient = measureCompositiveCoefficient;
    }

    public Long getMeasureSubjectId() {
        return measureSubjectId;
    }

    public void setMeasureSubjectId(Long measureSubjectId) {
        this.measureSubjectId = measureSubjectId;
    }

    public String getMeasureSubjectName() {
        return measureSubjectName;
    }

    public void setMeasureSubjectName(String measureSubjectName) {
        this.measureSubjectName = measureSubjectName;
    }

    public BigDecimal getMeasureTax() {
        return measureTax;
    }

    public void setMeasureTax(BigDecimal measureTax) {
        this.measureTax = measureTax;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getMeasureCode() {
        return measureCode;
    }

    /**
     * 编码
     */
    public void setMeasureCode(String measureCode) {
        this.measureCode = measureCode;
    }
    /**
     * 名称
     */
    public String getMeasureName() {
        return measureName;
    }

    /**
     * 名称
     */
    public void setMeasureName(String measureName) {
        this.measureName = measureName;
    }
    /**
     * 特征
     */
    public String getMeasureFeature() {
        return measureFeature;
    }

    /**
     * 特征
     */
    public void setMeasureFeature(String measureFeature) {
        this.measureFeature = measureFeature;
    }
    /**
     * 单位
     */
    public String getMeasureUnit() {
        return measureUnit;
    }

    /**
     * 单位
     */
    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getMeasureNum() {
        return measureNum;
    }

    /**
     * 工程量
     */
    public void setMeasureNum(java.math.BigDecimal measureNum) {
        this.measureNum = measureNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getMeasureTaxRate() {
        return measureTaxRate;
    }

    /**
     * 税率
     */
    public void setMeasureTaxRate(java.math.BigDecimal measureTaxRate) {
        this.measureTaxRate = measureTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public java.math.BigDecimal getMeasurePrice() {
        return measurePrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setMeasurePrice(java.math.BigDecimal measurePrice) {
        this.measurePrice = measurePrice;
    }
    /**
     * 综合单价(含税)
     */
    public java.math.BigDecimal getMeasureTaxPrice() {
        return measureTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setMeasureTaxPrice(java.math.BigDecimal measureTaxPrice) {
        this.measureTaxPrice = measureTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getMeasureMny() {
        return measureMny;
    }

    /**
     * 合价(无税)
     */
    public void setMeasureMny(java.math.BigDecimal measureMny) {
        this.measureMny = measureMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getMeasureTaxMny() {
        return measureTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setMeasureTaxMny(java.math.BigDecimal measureTaxMny) {
        this.measureTaxMny = measureTaxMny;
    }
    /**
     * 备注
     */
    public String getMeasureMemo() {
        return measureMemo;
    }

    /**
     * 备注
     */
    public void setMeasureMemo(String measureMemo) {
        this.measureMemo = measureMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    
}
