package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;

/**
 * 合同登记变更
 *
 * @author generator
 */
@TableName("ejc_income_contract_register_change")
public class ContractRegisterChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "register_id")
    private Long registerId; // 合同登记主键
    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "review_id")
    private Long reviewId; // 合同评审主键
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编号
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_code")
    private String orgCode; // 组织编码
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "bear_type")
    private Long bearType; // 承揽方式
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_type")
    private Long contractType; // 合同类型
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @TableField(value = "customer_id")
    private Long customerId; // 合同甲方
    @TableField(value = "customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 合同乙方
    @TableField(value = "supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value = "construction_partner")
    private String constructionPartner; // 施工联合方
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @TableField(value = "start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @TableField(value = "end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @TableField(value = "schedule")
    private Integer schedule; // 工期
    @TableField(value = "contract_valuation_type")
    private Long contractValuationType; // 合同计价形式，档案
    @TableField(value = "contract_status")
    private String contractStatus; // 合同状态：1-履约中, 2-已封账，3-已解除
    @TableField(value = "contract_partyc")
    private String contractPartyc; // 合同丙方
    @TableField(value = "conjoined_contract_total_mny")
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额
    @TableField(value = "cost_change_total_mny")
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    @TableField(value = "cost_change_total_tax_mny")
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    @TableField(value = "provisional_mny")
    private BigDecimal provisionalMny; // 暂列金额
    @TableField(value = "contract_promise_payment_rate")
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "dept_id")
    private Long deptId; // 经办部门
    @TableField(value = "dept_name")
    private String deptName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value = "base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value = "base_tax")
    private BigDecimal baseTax; // 初始版本税额
    @TableField(value = "before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value = "before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因
    @TableField(value = "before_contract_name")
    private String beforeContractName; // 变更前合同名称
    @TableField(value = "change_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date changeTime; // 变更（编制）时间
    @TableField(value = "used_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date usedTime; // 生效时间
    @TableField(value = "main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value = "main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value = "main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value = "supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value = "supplier_phone")
    private String supplierPhone; // 乙方电话
    @TableField(value = "customer_phone")
    private String customerPhone; // 甲方电话
    @TableField(value = "customer_entrusted_agent")
    private String customerEntrustedAgent; // 甲方委托代理人
    @TableField(value = "supplier_entrusted_agent")
    private String supplierEntrustedAgent; // 乙方委托代理人
    @TableField(value = "dispute_resolution")
    private Long disputeResolution; // 争议解决方式
    @TableField(value = "dispute_resolution_agency")
    private String disputeResolutionAgency; // 争议解决机构
    @TableField(value = "settlement_type")
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算

    @TableField(value = "supplement_content")
    private String supplementContent; // 协议内容
    @TableField(value = "contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value = "not_include_provisional_mny")
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)

    @TableField(value = "change_name")
    private String changeName; // 变更名称
    @TableField(value = "this_change_tax_mny")
    private BigDecimal thisChangeTaxMny; // 本次变更金额
    @TableField(value = "this_change_mny")
    private BigDecimal thisChangeMny; // 本次变更金额(无税)
    @TableField(value = "this_change_tax")
    private BigDecimal thisChangeTax; // 本次变更税额
    @TableField(value = "this_change_rate")
    private String thisChangeRate; // 本次变更比例

    @TableField(value = "is_estimation")
    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    @TableField(value = "total_cost_adjust_tax_mny")
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    @TableField(value = "total_cost_adjust_mny")
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    @TableField(value = "total_cost_adjust_tax")
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    @TableField(value = "total_after_cost_adjust_tax_mny")
    private BigDecimal totalAfterCostAdjustTaxMny; // 工程造价调整后总金额
    @TableField(value = "total_after_cost_adjust_mny")
    private BigDecimal totalAfterCostAdjustMny; // 工程造价调整后总金额(无税)
    @TableField(value = "total_after_cost_adjust_tax")
    private BigDecimal totalAfterCostAdjustTax; // 工程造价调整后税额
    @TableField(value = "nic_contract_mny")
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)

    @TableField(value = "progress_payment_clause")
    private String progressPaymentClause; // 工程进度款支付条款



    public String getProgressPaymentClause() {
        return progressPaymentClause;
    }

    public void setProgressPaymentClause(String progressPaymentClause) {
        this.progressPaymentClause = progressPaymentClause;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalAfterCostAdjustTaxMny() {
        return totalAfterCostAdjustTaxMny;
    }

    public void setTotalAfterCostAdjustTaxMny(BigDecimal totalAfterCostAdjustTaxMny) {
        this.totalAfterCostAdjustTaxMny = totalAfterCostAdjustTaxMny;
    }

    public BigDecimal getTotalAfterCostAdjustMny() {
        return totalAfterCostAdjustMny;
    }

    public void setTotalAfterCostAdjustMny(BigDecimal totalAfterCostAdjustMny) {
        this.totalAfterCostAdjustMny = totalAfterCostAdjustMny;
    }

    public BigDecimal getTotalAfterCostAdjustTax() {
        return totalAfterCostAdjustTax;
    }

    public void setTotalAfterCostAdjustTax(BigDecimal totalAfterCostAdjustTax) {
        this.totalAfterCostAdjustTax = totalAfterCostAdjustTax;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public String getChangeName() {
        return changeName;
    }

    public void setChangeName(String changeName) {
        this.changeName = changeName;
    }

    public BigDecimal getThisChangeTaxMny() {
        return thisChangeTaxMny;
    }

    public void setThisChangeTaxMny(BigDecimal thisChangeTaxMny) {
        this.thisChangeTaxMny = thisChangeTaxMny;
    }

    public BigDecimal getThisChangeMny() {
        return thisChangeMny;
    }

    public void setThisChangeMny(BigDecimal thisChangeMny) {
        this.thisChangeMny = thisChangeMny;
    }

    public BigDecimal getThisChangeTax() {
        return thisChangeTax;
    }

    public void setThisChangeTax(BigDecimal thisChangeTax) {
        this.thisChangeTax = thisChangeTax;
    }

    public String getThisChangeRate() {
        return thisChangeRate;
    }

    public void setThisChangeRate(String thisChangeRate) {
        this.thisChangeRate = thisChangeRate;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    /**
     * 合同登记主键
     */
    public Long getRegisterId() {
        return registerId;
    }

    /**
     * 合同登记主键
     */
    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 合同评审主键
     */
    public Long getReviewId() {
        return reviewId;
    }

    /**
     * 合同评审主键
     */
    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 承揽方式
     */
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 合同类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }

    /**
     * 合同甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 合同乙方
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }

    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    /**
     * 合同(签订)金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同(签订)金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }

    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    /**
     * 联体合同总金额
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总金额
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额(无税)
     */
    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额(无税)
     */
    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额
     */
    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额
     */
    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    /**
     * 暂列金额
     */
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    /**
     * 暂列金额
     */
    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    /**
     * 合同约定收款比例
     */
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    /**
     * 合同约定收款比例
     */
    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }

    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 变更前合同名称
     */
    public String getBeforeContractName() {
        return beforeContractName;
    }

    /**
     * 变更前合同名称
     */
    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    /**
     * 变更（编制）时间
     */
    public java.util.Date getChangeTime() {
        return changeTime;
    }

    /**
     * 变更（编制）时间
     */
    public void setChangeTime(java.util.Date changeTime) {
        this.changeTime = changeTime;
    }

    /**
     * 生效时间
     */
    public java.util.Date getUsedTime() {
        return usedTime;
    }

    /**
     * 生效时间
     */
    public void setUsedTime(java.util.Date usedTime) {
        this.usedTime = usedTime;
    }

    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 乙方电话
     */
    public String getSupplierPhone() {
        return supplierPhone;
    }

    /**
     * 乙方电话
     */
    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    /**
     * 甲方电话
     */
    public String getCustomerPhone() {
        return customerPhone;
    }

    /**
     * 甲方电话
     */
    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    /**
     * 甲方委托代理人
     */
    public String getCustomerEntrustedAgent() {
        return customerEntrustedAgent;
    }

    /**
     * 甲方委托代理人
     */
    public void setCustomerEntrustedAgent(String customerEntrustedAgent) {
        this.customerEntrustedAgent = customerEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public String getSupplierEntrustedAgent() {
        return supplierEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public void setSupplierEntrustedAgent(String supplierEntrustedAgent) {
        this.supplierEntrustedAgent = supplierEntrustedAgent;
    }

    /**
     * 争议解决方式
     */
    public Long getDisputeResolution() {
        return disputeResolution;
    }

    /**
     * 争议解决方式
     */
    public void setDisputeResolution(Long disputeResolution) {
        this.disputeResolution = disputeResolution;
    }

    /**
     * 争议解决机构
     */
    public String getDisputeResolutionAgency() {
        return disputeResolutionAgency;
    }

    /**
     * 争议解决机构
     */
    public void setDisputeResolutionAgency(String disputeResolutionAgency) {
        this.disputeResolutionAgency = disputeResolutionAgency;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 协议内容
     */
    public String getSupplementContent() {
        return supplementContent;
    }

    /**
     * 协议内容
     */
    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
}
