package com.ejianc.business.pro.arch.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.arch.utils.DetailIndexExcelReader2;
import com.ejianc.business.pro.arch.vo.ArchitectVO;
import com.ejianc.business.pro.income.vo.ImportErrorVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.arch.mapper.ArchitectMapper;
import com.ejianc.business.pro.arch.bean.ArchitectEntity;
import com.ejianc.business.pro.arch.service.IArchitectService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 建造师
 * 
 * @author generator
 * 
 */
@Service("architectService")
public class ArchitectServiceImpl extends BaseServiceImpl<ArchitectMapper, ArchitectEntity> implements IArchitectService{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "ARC_N_C";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result != null && result.size() > 0) {
                List<ArchitectEntity> arcList = new ArrayList<>();
                Map<String, Long> collect = new HashMap<>();
                OrgVO data;
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-mm-dd");
                CommonResponse<List<DefdocDetailVO>> defDocByDefId = defdocApi.getDefDocByDefId(744509734572658785L);
                if(defDocByDefId.isSuccess()) {
                    List<DefdocDetailVO> ddd = defDocByDefId.getData();
                    collect = ddd.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
                }else{
                    throw new BusinessException("网络异常， 查询自定义档案失败， 请稍后再试");
                }

                CommonResponse<OrgVO> oneById = iOrgApi.getOneById(InvocationInfoProxy.getOrgId());
                if(oneById.isSuccess()) {
                    data = oneById.getData();
                }else{
                    throw new BusinessException("网络异常，查询组织信息失败， 请稍后再试");
                }

                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    ArchitectVO architectVO = new ArchitectVO();
                    boolean flag = false;
                    String warnType = "";
                    if (StringUtils.isNotBlank(datas.get(0))) {
                        String name = datas.get(0);//姓名
                        architectVO.setName(name);
                    }
                    if (StringUtils.isNotBlank(datas.get(1))) {
                        String idCard = datas.get(1);//身份证号
                        architectVO.setIdCard(idCard);
                    }

                    if (StringUtils.isNotBlank(datas.get(2))) {
                        String sex = datas.get(2);//性别 下拉]
                        architectVO.setSex("男".equals(sex)?"1":"2");
                    }
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        String age = datas.get(3);//身份证号
                        architectVO.setUserAge(Integer.parseInt(age));
                    }
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        String architectMajorName = datas.get(4);//建造师专业 参照
                        architectVO.setArchitectMajorName(architectMajorName);
                        architectVO.setArchitectMajor(collect.get(architectMajorName));
                    }

                    if (StringUtils.isNotBlank(datas.get(5))) {
                        String registrationNumber = datas.get(5);//注册编号
                        architectVO.setRegistrationNumber(registrationNumber);
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        String validity = datas.get(6);//有效期止
                        Date date = null;
                        try {
                            date = ft.parse(validity);
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        architectVO.setValidity(date);

                    }
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        String certificateNumber = datas.get(7);//B类证号
                        architectVO.setCertificateNumber(certificateNumber);
                    }
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        String certificateValidity = datas.get(8);//B类有效期止
                        Date date = null;
                        try {
                            date = ft.parse(certificateValidity);
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        architectVO.setCertificateValidity(date);

                    }

                    if (StringUtils.isNotBlank(datas.get(9))) {
                        String titleLevel = datas.get(9);//技术职称等级
                        switch(titleLevel) {
                            case "正高级":
                                architectVO.setTitleLevel("0");
                                break;
                            case "副高级":
                                architectVO.setTitleLevel("1");
                                break;
                            case "中级":
                                architectVO.setTitleLevel("2");
                                break;
                            case "初级":
                                architectVO.setTitleLevel("3");
                                break;
                            case "员级":
                                architectVO.setTitleLevel("4");
                                break;
                            default:
                                break;
                        }
                    }
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        String addItemOne = datas.get(10);//增项1
                        architectVO.setAddItemOne(addItemOne);
                    }
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        String addItemTwo = datas.get(11);//增项2
                        architectVO.setAddItemTwo(addItemTwo);
                    }

                    if (StringUtils.isNotBlank(datas.get(12))) {
                        String addItemThree = datas.get(12);//增项3
                        architectVO.setAddItemThree(addItemThree);
                    }
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        String memo = datas.get(13);//备注
                        architectVO.setMemo(memo);
                    }
                    architectVO.setEmployeeId(InvocationInfoProxy.getUserid());
                    architectVO.setEmployeeName("系统管理员");
                    architectVO.setBillState(1);
                    architectVO.setOrgId(InvocationInfoProxy.getOrgId());
                    architectVO.setOrgName(data.getName());
                    ArchitectEntity entity = BeanMapper.map(architectVO, ArchitectEntity.class);
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),architectVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    arcList.add(entity);
                }
                logger.error("导入数据：" + JSONObject.toJSONString(arcList));

//                super.saveOrUpdateBatch(arcList);
                }
        }
        return null;
    }
}
