package com.ejianc.business.pro.income.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.income.bean.QuoteDetailEntity;
/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_quote")
public class QuoteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 合同税率
    @TableField(value="contract_mny")
    private java.math.BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private java.math.BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="quote_date")
    private java.util.Date quoteDate; // 报量时间
    @TableField(value="quote_mny")
    private java.math.BigDecimal quoteMny; // 本次上报金额(无税)
    @TableField(value="quote_tax_mny")
    private java.math.BigDecimal quoteTaxMny; // 本次上报金额
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 部门id
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="reply_date")
    private java.util.Date replyDate; // 批复时间
    @TableField(value="reply_status")
    private Integer replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    @TableField(value="reply_mny")
    private java.math.BigDecimal replyMny; // 本次批复金额(无税)
    @TableField(value="reply_tax_mny")
    private java.math.BigDecimal replyTaxMny; // 本次批复金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="applied_tax_mny")
    private BigDecimal appliedTaxMny; //已申请金额(不含本次)
    @TableField(value="applied_mny")
    private BigDecimal appliedMny; //已申请金额(不含本次)(无税)
    @TableField(value="production_ascription_years")
    private Date productionAscriptionYears; // 产值归属年月
    @TableField(value="production_contain")
    private Integer productionContain; // 产值包含关系--1--是--0--否
    @TableField(value="construction_budget_mny")
    private BigDecimal constructionBudgetMny; // 施工图预算金额
    @TableField(value="contract_payment_rate")
    private BigDecimal contractPaymentRate; // 合同收款比例
    @TableField(value="sum_check_production")
    private BigDecimal sumCheckProduction; // 累计审定产值
    @TableField(value="production_contain_claim_mny")
    private BigDecimal productionContainClaimMny; // 产值含变更签证\索赔金额
    @TableField(value="check_production_company")
    private BigDecimal checkProductionCompany; // 审定产值归公司
    @TableField(value="check_production_group")
    private BigDecimal checkProductionGroup; // 审定产值归集团
    @TableField(value="completed_not_approval_production")
    private BigDecimal completedNotApprovalProduction; // 已完成未审批产值
    @TableField(value="month_receivable_engineering_mny")
    private BigDecimal monthReceivableEngineeringMny; // 本月应收工程款
    @TableField(value="sum_receivable_engineering_mny")
    private BigDecimal sumReceivableEngineeringMny; // 累计应收工程款
    @TableField(value="forecast_production_company")
    private BigDecimal forecastProductionCompany; // 预报产值归公司
    @TableField(value="forecast_production_group")
    private BigDecimal forecastProductionGroup; // 预报产值归集团
    @TableField(value="report_produce_management_production")
    private BigDecimal reportProduceManagementProduction; // 报生产管理部产值
    @TableField(value="remainder_report_produce_mny")
    private BigDecimal remainderReportProduceMny; // 剩余可报产值金额
    @TableField(value="last_check_production_company")
    private BigDecimal lastCheckProductionCompany; // 累计审定产值归公司
    @TableField(value="last_check_production_group")
    private BigDecimal lastCheckProductionGroup; // 累计审定产值归集团
    @TableField(value="predict_complete_date")
    private Date predictCompleteDate; // 预计完（竣）工日期

    @TableField(value="commit_date")
    private Date commitDate; // 提交时间
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailService", pidName = "quoteId")
    private List<QuoteDetailEntity> detailList = new ArrayList<>(); // 对甲报量子表
    @TableField(value="sum_actual_mny")
    private BigDecimal sumActualMny; // 累计实际完成产值
    @TableField(value="sum_actual_mny_tax")
    private BigDecimal sumActualMnyTax; // 累计实际完成产值
    @TableField(value="diff_mny")
    private BigDecimal diffMny; // 产值偏差值
    @TableField(value="production_type_id")
    private Long productionTypeId;//产值类型
    @TableField(value="production_type_name")
    private String productionTypeName;//产值类型

    public BigDecimal getSumActualMnyTax() {
        return sumActualMnyTax;
    }

    public void setSumActualMnyTax(BigDecimal sumActualMnyTax) {
        this.sumActualMnyTax = sumActualMnyTax;
    }

    public BigDecimal getSumActualMny() {
        return sumActualMny;
    }

    public void setSumActualMny(BigDecimal sumActualMny) {
        this.sumActualMny = sumActualMny;
    }

    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }

    public Long getProductionTypeId() {
        return productionTypeId;
    }

    public void setProductionTypeId(Long productionTypeId) {
        this.productionTypeId = productionTypeId;
    }

    public String getProductionTypeName() {
        return productionTypeName;
    }

    public void setProductionTypeName(String productionTypeName) {
        this.productionTypeName = productionTypeName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(无税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(无税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额(含税)
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 报量时间
     */
    public java.util.Date getQuoteDate() {
        return quoteDate;
    }

    /**
     * 报量时间
     */
    public void setQuoteDate(java.util.Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    /**
     * 本次上报金额(无税)
     */
    public java.math.BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(java.math.BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public java.math.BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(java.math.BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 部门id
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 部门id
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 批复时间
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 批复时间
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public Integer getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 本次批复金额(无税)
     */
    public java.math.BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 本次批复金额(无税)
     */
    public void setReplyMny(java.math.BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 本次批复金额
     */
    public java.math.BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 本次批复金额
     */
    public void setReplyTaxMny(java.math.BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
    /**
     * 对甲报量子表
     */
    public List<QuoteDetailEntity> getDetailList() {
        return detailList;
    }

    /**
     * 对甲报量子表
     */
    public void setDetailList(List<QuoteDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAppliedTaxMny() {
        return appliedTaxMny;
    }

    public void setAppliedTaxMny(BigDecimal appliedTaxMny) {
        this.appliedTaxMny = appliedTaxMny;
    }

    public BigDecimal getAppliedMny() {
        return appliedMny;
    }

    public void setAppliedMny(BigDecimal appliedMny) {
        this.appliedMny = appliedMny;
    }

    public Date getProductionAscriptionYears() {
        return productionAscriptionYears;
    }

    public void setProductionAscriptionYears(Date productionAscriptionYears) {
        this.productionAscriptionYears = productionAscriptionYears;
    }

    public Integer getProductionContain() {
        return productionContain;
    }

    public void setProductionContain(Integer productionContain) {
        this.productionContain = productionContain;
    }

    public BigDecimal getConstructionBudgetMny() {
        return constructionBudgetMny;
    }

    public void setConstructionBudgetMny(BigDecimal constructionBudgetMny) {
        this.constructionBudgetMny = constructionBudgetMny;
    }

    public BigDecimal getContractPaymentRate() {
        return contractPaymentRate;
    }

    public void setContractPaymentRate(BigDecimal contractPaymentRate) {
        this.contractPaymentRate = contractPaymentRate;
    }

    public BigDecimal getSumCheckProduction() {
        return sumCheckProduction;
    }

    public void setSumCheckProduction(BigDecimal sumCheckProduction) {
        this.sumCheckProduction = sumCheckProduction;
    }

    public BigDecimal getProductionContainClaimMny() {
        return productionContainClaimMny;
    }

    public void setProductionContainClaimMny(BigDecimal productionContainClaimMny) {
        this.productionContainClaimMny = productionContainClaimMny;
    }

    public BigDecimal getCheckProductionCompany() {
        return checkProductionCompany;
    }

    public void setCheckProductionCompany(BigDecimal checkProductionCompany) {
        this.checkProductionCompany = checkProductionCompany;
    }

    public BigDecimal getCheckProductionGroup() {
        return checkProductionGroup;
    }

    public void setCheckProductionGroup(BigDecimal checkProductionGroup) {
        this.checkProductionGroup = checkProductionGroup;
    }

    public BigDecimal getCompletedNotApprovalProduction() {
        return completedNotApprovalProduction;
    }

    public void setCompletedNotApprovalProduction(BigDecimal completedNotApprovalProduction) {
        this.completedNotApprovalProduction = completedNotApprovalProduction;
    }

    public BigDecimal getMonthReceivableEngineeringMny() {
        return monthReceivableEngineeringMny;
    }

    public void setMonthReceivableEngineeringMny(BigDecimal monthReceivableEngineeringMny) {
        this.monthReceivableEngineeringMny = monthReceivableEngineeringMny;
    }

    public BigDecimal getSumReceivableEngineeringMny() {
        return sumReceivableEngineeringMny;
    }

    public void setSumReceivableEngineeringMny(BigDecimal sumReceivableEngineeringMny) {
        this.sumReceivableEngineeringMny = sumReceivableEngineeringMny;
    }

    public BigDecimal getForecastProductionCompany() {
        return forecastProductionCompany;
    }

    public void setForecastProductionCompany(BigDecimal forecastProductionCompany) {
        this.forecastProductionCompany = forecastProductionCompany;
    }

    public BigDecimal getForecastProductionGroup() {
        return forecastProductionGroup;
    }

    public void setForecastProductionGroup(BigDecimal forecastProductionGroup) {
        this.forecastProductionGroup = forecastProductionGroup;
    }

    public BigDecimal getReportProduceManagementProduction() {
        return reportProduceManagementProduction;
    }

    public void setReportProduceManagementProduction(BigDecimal reportProduceManagementProduction) {
        this.reportProduceManagementProduction = reportProduceManagementProduction;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public BigDecimal getRemainderReportProduceMny() {
        return remainderReportProduceMny;
    }

    public void setRemainderReportProduceMny(BigDecimal remainderReportProduceMny) {
        this.remainderReportProduceMny = remainderReportProduceMny;
    }

    public BigDecimal getLastCheckProductionCompany() {
        return lastCheckProductionCompany;
    }

    public void setLastCheckProductionCompany(BigDecimal lastCheckProductionCompany) {
        this.lastCheckProductionCompany = lastCheckProductionCompany;
    }

    public BigDecimal getLastCheckProductionGroup() {
        return lastCheckProductionGroup;
    }

    public void setLastCheckProductionGroup(BigDecimal lastCheckProductionGroup) {
        this.lastCheckProductionGroup = lastCheckProductionGroup;
    }

    public Date getPredictCompleteDate() {
        return predictCompleteDate;
    }

    public void setPredictCompleteDate(Date predictCompleteDate) {
        this.predictCompleteDate = predictCompleteDate;
    }
}
