package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("contractRegister") 
public class ContractRegisterBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;
	
	@Autowired
	private IContractRegisterService service;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("提交回写合同状态开始");
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
		wrapper.eq(ContractRegisterEntity::getId, billId);
		service.update(wrapper);

		logger.info("提交回写合同状态结束");

		ContractRegisterEntity contractEntity = service.selectById(billId);
		//合同推送合同池
		boolean pushResult = service.pushContract(BeanMapper.map(contractEntity, ContractRegisterVO.class),false);
		if(pushResult) {
			contractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}

		service.saveOrUpdate(contractEntity);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractRegisterEntity entity = service.selectById(billId);
		if (entity.getSupplementFlag() == 1) {
			return CommonResponse.error("补充协议暂不支持回退功能!");
		}else {
			// 合同是否被其他单据引用
			CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
			logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
			if(res.isSuccess()) {
				// 单据未被下游单据引用
				// 回写合同解除状态
				LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.未签订.getCode());
				wrapper.eq(BaseEntity::getId, billId);


				//从合同池删除数据
				boolean delResult = service.delContractFromPool(billId);
				if(delResult) {
					wrapper.set(ContractRegisterEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
					service.update(wrapper);
				}

				return CommonResponse.success();
			}else{
				return CommonResponse.error(res.getMsg());
			}
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
