package com.ejianc.business.pro.warn;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/2/13 20:19
 */
@RestController
@RequestMapping(value = "/settleReportMemoTask/")
public class SettleReportMemoTask {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettleReportService settleReportService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IUserApi userApi;

    private final String MSG_CONTENT = "请维护项目工程报审备忘录";
    private final String SYS_ADMIN_EMP_ID = "1247777316689256450";
    private final String SYS_ADMIN_UID = "303581417601122400";

    @PostMapping(value = "memoMaintenance")
    public CommonResponse<String> memoMaintenance(@RequestParam Integer days, @RequestParam(required = false) String deptCode, @RequestParam(required = false) String roleName) {
        logger.info("检测是否存在待维护【备忘录】的【结算报审】任务, 间隔天数【{}】----START----", days);

        //1、查询是否存在需要维护备忘录的结算报审
        List<SettleReportEntity> reportEntities = settleReportService.checkMemoMaintenance(days);

        if(CollectionUtils.isEmpty(reportEntities)) {
            logger.info("待维护备忘录的结算报审列表为空，本次任务结束----END----");
            return CommonResponse.success("待维护备忘录的结算报审列表为空，本次任务结束！");
        }

        //2、有需要维护【备忘录】的结算报审，组装提示信息，发送给结算报审的经办人和消息接收人
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息内容
        msgParameter.setSubject(MSG_CONTENT);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(reportEntities.get(0).getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(Long.valueOf(SYS_ADMIN_UID));
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        Map<Long, List<SettleReportEntity>> settleReportGroupByProject = reportEntities.stream().collect(Collectors.groupingBy(SettleReportEntity::getProjectId));
        settleReportGroupByProject.values().stream().forEach(settleReports -> {
            List<String> recUserIds = new ArrayList<>();
            //消息主题
            msgParameter.setContent("请维护项目【"+settleReports.get(0).getProjectName()+"】工程报审备忘录。");
            settleReports.stream().forEach(settleReport -> {
                if(SYS_ADMIN_EMP_ID.equals(settleReport.getEmployeeId().toString())) {
                    if(!recUserIds.contains(SYS_ADMIN_UID)) {
                        recUserIds.add(SYS_ADMIN_UID);
                    }
                } else if(!recUserIds.contains(settleReport.getEmployeeId().toString())) {
                    recUserIds.add(settleReport.getEmployeeId().toString());
                }
            });

            //对指定部门下用户进行发送消息
            if(StringUtils.isNotBlank(deptCode)) {
                //查询指定部门编码下的人员
                CommonResponse<List<EmployeeVO>> empResp =employeeApi.queryEmployeeByDeptCode(deptCode);
                if(!empResp.isSuccess()) {
                    logger.error("根据部门编码{}查询对应人员列表失败，{}, 跳过对指定角色下用户进行发送消息", deptCode, JSONObject.toJSONString(empResp));
                } else {
                    empResp.getData().forEach(emp -> {
                        if(SYS_ADMIN_EMP_ID.equals(emp.getId().toString())) {
                            if(!recUserIds.contains(SYS_ADMIN_UID)) {
                                recUserIds.add(SYS_ADMIN_UID);
                            }
                        } else if(!recUserIds.contains(emp.getId().toString())) {
                            recUserIds.add(emp.getId().toString());
                        }
                    });
                }
            }

            //对指定角色霞用户发送消息
            if(StringUtils.isNotBlank(roleName)) {
                List<String> roleNames = new ArrayList<>();
                roleNames.add(roleName);
                //根据角色查询对用用户
                CommonResponse<List<UserVO>> userResp = userApi.findAllUserByRoleNameList(roleNames);
                if(!userResp.isSuccess()) {
                    logger.error("根据角色名称：{}获取用户列表失败：{}, 跳过对指定角色下用户进行发送消息", roleName, JSONObject.toJSONString(userResp));
                } else {
                    List<UserVO> users = userResp.getData();
                    if(CollectionUtils.isNotEmpty(users)) {
                        users.forEach(u -> recUserIds.add(u.getId().toString()));
                    }
                }
            }

            msgParameter.setReceivers(recUserIds.toArray(new String[recUserIds.size()]));
            logger.info("项目[{}]备忘录提示人员列表: {}", settleReports.get(0).getProjectName(), recUserIds);
            pushMessageApi.pushMessage(msgParameter);
        });

        logger.info("检测是否存在待维护【备忘录】的【结算报审】任务----END----");
        return CommonResponse.success("检测是否存在待维护【备忘录】的【结算报审】任务执行结束！");
    }
}
