/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class DetailIndexExcelReader {
    public static List<List<List<String>>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            return DetailIndexExcelReader.read2003Excel(file);
        }
        if ("xlsx".equals(extName)) {
            return DetailIndexExcelReader.read2007Excel(file);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<List<String>>> read2003Excel(MultipartFile file) {
        HSSFWorkbook hwb;
        LinkedList<List<List<String>>> resList = new LinkedList<List<List<String>>>();
        try {
            hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }
        int size = hwb.getNumberOfSheets();
        for (int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                if (row == null) continue;
                int rowLastCellNum = sheet.getRow(0).getLastCellNum();
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    if (headLength == 0) {
                        linked.add(DetailIndexExcelReader.get2003DetailIndex(cell));
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            String[] stringArray;
                            DecimalFormat df = new DecimalFormat("#.########");
                            value = df.format(cell.getNumericCellValue());
                            if (null == value || "".equals(value.trim()) || 1 >= (stringArray = value.split("[.]")).length || !"0".equals(stringArray[1]) && !"00".equals(stringArray[1]) && !"000".equals(stringArray[1]) && !"0000".equals(stringArray[1])) break;
                            value = stringArray[0];
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            value = String.valueOf(cell.getNumericCellValue());
                            if (!value.equals("NaN")) break;
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        default: {
                            value = cell.getStringCellValue() + "";
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = ((List)list.get(0)).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var17_22;
                        int n = nowLinkLength;
                        while (var17_22 < headLength) {
                            linked.add(null);
                            ++var17_22;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) break;
                list.add(linked);
            }
            resList.add(list);
        }
        return resList;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<List<String>>> read2007Excel(MultipartFile file) {
        XSSFWorkbook xwb;
        LinkedList<List<List<String>>> resList = new LinkedList<List<List<String>>>();
        try {
            xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }
        int size = xwb.getNumberOfSheets();
        for (int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                int rowLastCellNum = sheet.getRow(0).getLastCellNum();
                if (row == null) continue;
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    if (headLength == 0) {
                        linked.add(DetailIndexExcelReader.get2007DetailIndex(cell));
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            String[] stringArray;
                            DecimalFormat df = new DecimalFormat("#.########");
                            value = df.format(cell.getNumericCellValue());
                            if (null == value || "".equals(value.trim()) || 1 >= (stringArray = value.split("[.]")).length || !"0".equals(stringArray[1]) && !"00".equals(stringArray[1]) && !"000".equals(stringArray[1]) && !"0000".equals(stringArray[1])) break;
                            value = stringArray[0];
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            value = String.valueOf(cell.getNumericCellValue());
                            if (!value.equals("NaN")) break;
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        default: {
                            value = cell.getStringCellValue() + "";
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = ((List)list.get(0)).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var17_22;
                        int n = nowLinkLength;
                        while (var17_22 < headLength) {
                            linked.add(null);
                            ++var17_22;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) break;
                list.add(linked);
            }
            resList.add(list);
        }
        return resList;
    }

    private static String get2003DetailIndex(HSSFCell cell) {
        String val = "";
        try {
            cell.setCellType(1);
            val = cell.getStringCellValue();
        }
        catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            }
            catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    private static String get2007DetailIndex(XSSFCell cell) {
        String val = "";
        try {
            cell.setCellType(1);
            val = cell.getStringCellValue();
        }
        catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            }
            catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    public static Integer getNumberOfSheets(MultipartFile file) {
        String originalFileName = new String(file.getOriginalFilename());
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            HSSFWorkbook hwb;
            try {
                hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
            }
            catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return hwb.getNumberOfSheets();
        }
        if ("xlsx".equals(extName)) {
            XSSFWorkbook xwb;
            try {
                xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
            }
            catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return xwb.getNumberOfSheets();
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }
}

