package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;

/**
 * 施工合同评审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_contract_review")
public class ContractReviewEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_name")
    private String contractName; // 工程名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_mny")
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="contract_tax_mny")
    private java.math.BigDecimal contractTaxMny; // 合同金额
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方
    @TableField(value="customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 合同乙方
    @TableField(value="supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value="construction_partner")
    private String constructionPartner; // 施工联合方
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 合同税率
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税额
    @TableField(value="contract_type")
    private Long contractType; // 合同类型
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 合同计价形式，档案
    @TableField(value="built_area")
    private java.math.BigDecimal builtArea; // 建筑面积(㎡)
    @TableField(value="contract_partyc")
    private String contractPartyc; // 合同丙方
    @TableField(value="conjoined_contract_total_mny")
    private java.math.BigDecimal conjoinedContractTotalMny; // 联体合同总造价
    @TableField(value="architect_id")
    private Long architectId; // 建造师
    @TableField(value="architect_name")
    private String architectName; // 建造师名称
    @TableField(value="manager_id")
    private Long managerId; // 项目责任人
    @TableField(value="manager_name")
    private String managerName; // 项目责任人名称
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类型
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类型名称
    @TableField(value="settlement_type")
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    @TableField(value="address")
    private String address; // 项目地址
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="brief_description")
    private String briefDescription; // 补充协议简要说明
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="contract_scope")
    private String contractScope; // 承包范围
    @TableField(value="funds_source")
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @TableField(value="schedule")
    private Integer schedule; // 工期
    @TableField(value="quality_requirement")
    private String qualityRequirement; // 质量要求
    @TableField(value="safety_goal")
    private String safetyGoal; // 安全目标
    @TableField(value="civilization_construction_goal")
    private String civilizationConstructionGoal; // 文明施工目标
    @TableField(value="advance_payment")
    private Integer advancePayment; // 预付款：0-无，1-有
    @TableField(value="progress_payment")
    private Integer progressPayment; // 工程进度款支付：0-按节点支付，2-按月支付
    @TableField(value="node_payment")
    private String nodePayment; // 按节点支付
    @TableField(value="month_payment")
    private String monthPayment; // 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
    @TableField(value="quality_deposit")
    private String qualityDeposit; // 质量保证金：0-3%，1-5%
    @TableField(value="price_adjustment")
    private String priceAdjustment; // 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
    @TableField(value="price_adjustment_detail")
    private String priceAdjustmentDetail; // 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    @TableField(value="breach")
    private String breach; // 违约

    
    @TableField(value="advance_payment_info")
    private java.lang.String advancePaymentInfo; // 预付款信息
    @TableField(value="price_adjustment_second")
    private java.lang.String priceAdjustmentSecond; // 价格调整2：0-采用造价信息进行价格调整，1-采用价格指数进行价格调整，2-专用合同条款约定的其他方式
    @TableField(value="price_adjustment_third")
    private java.lang.String priceAdjustmentThird; // 价格调整3：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    @TableField(value="price_adjustment_info")
    private java.lang.String priceAdjustmentInfo; // 法律变化引起的调整信息
    @TableField(value="price_adjustment_third_two")
    private java.lang.String priceAdjustmentThirdTwo; // 采用价格指数进行价格调整信息
    @TableField(value="price_adjustment_third_three")
    private java.lang.String priceAdjustmentThirdThree; // 专用合同条款约定的其他方式信息
    @TableField(value="other_terms")
    private String otherTerms; // 其它条款
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value="bear_type")
    private Long bearType; // 承揽方式
    @TableField(value = "construct_id")
    private Long constructId;
    @TableField(value = "construct_name")
    private String constructName;//建设单位

    @TableField(value="funds_source_id")
    private Long fundsSourceId; // 资金来源(自定义档案)
    @TableField(value="price_adjustment_third_one")
    private java.lang.String priceAdjustmentThirdOne; // 采用价格信息进行价格调整信息
    @TableField(value="payment_term")
    private String paymentTerm; //支付条款描述
    @TableField(value="fixed_payment_rate")
    private BigDecimal fixedPaymentRate; //固定付款比例

    public String getPriceAdjustmentThirdOne() {
        return priceAdjustmentThirdOne;
    }

    public void setPriceAdjustmentThirdOne(String priceAdjustmentThirdOne) {
        this.priceAdjustmentThirdOne = priceAdjustmentThirdOne;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getFixedPaymentRate() {
        return fixedPaymentRate;
    }

    public void setFixedPaymentRate(BigDecimal fixedPaymentRate) {
        this.fixedPaymentRate = fixedPaymentRate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 工程名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 合同乙方
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 建筑面积(㎡)
     */
    public java.math.BigDecimal getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积(㎡)
     */
    public void setBuiltArea(java.math.BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }
    /**
     * 联体合同总造价
     */
    public java.math.BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总造价
     */
    public void setConjoinedContractTotalMny(java.math.BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }
    /**
     * 建造师
     */
    public Long getArchitectId() {
        return architectId;
    }

    /**
     * 建造师
     */
    public void setArchitectId(Long architectId) {
        this.architectId = architectId;
    }
    /**
     * 建造师名称
     */
    public String getArchitectName() {
        return architectName;
    }

    /**
     * 建造师名称
     */
    public void setArchitectName(String architectName) {
        this.architectName = architectName;
    }
    /**
     * 项目责任人
     */
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 项目责任人
     */
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    /**
     * 项目责任人名称
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 项目责任人名称
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 工程类型
     */
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类型
     */
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 项目地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 项目地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 补充协议简要说明
     */
    public String getBriefDescription() {
        return briefDescription;
    }

    /**
     * 补充协议简要说明
     */
    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }
    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }
    /**
     * 质量要求
     */
    public String getQualityRequirement() {
        return qualityRequirement;
    }

    /**
     * 质量要求
     */
    public void setQualityRequirement(String qualityRequirement) {
        this.qualityRequirement = qualityRequirement;
    }
    /**
     * 安全目标
     */
    public String getSafetyGoal() {
        return safetyGoal;
    }

    /**
     * 安全目标
     */
    public void setSafetyGoal(String safetyGoal) {
        this.safetyGoal = safetyGoal;
    }
    /**
     * 文明施工目标
     */
    public String getCivilizationConstructionGoal() {
        return civilizationConstructionGoal;
    }

    /**
     * 文明施工目标
     */
    public void setCivilizationConstructionGoal(String civilizationConstructionGoal) {
        this.civilizationConstructionGoal = civilizationConstructionGoal;
    }
    /**
     * 预付款：0-无，1-有
     */
    public Integer getAdvancePayment() {
        return advancePayment;
    }

    /**
     * 预付款：0-无，1-有
     */
    public void setAdvancePayment(Integer advancePayment) {
        this.advancePayment = advancePayment;
    }
    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public Integer getProgressPayment() {
        return progressPayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public void setProgressPayment(Integer progressPayment) {
        this.progressPayment = progressPayment;
    }
    /**
     * 按节点支付
     */
    public String getNodePayment() {
        return nodePayment;
    }

    /**
     * 按节点支付
     */
    public void setNodePayment(String nodePayment) {
        this.nodePayment = nodePayment;
    }
    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public String getMonthPayment() {
        return monthPayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public void setMonthPayment(String monthPayment) {
        this.monthPayment = monthPayment;
    }
    /**
     * 质量保证金：0-3%，1-5%
     */
    public String getQualityDeposit() {
        return qualityDeposit;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public void setQualityDeposit(String qualityDeposit) {
        this.qualityDeposit = qualityDeposit;
    }
    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public String getPriceAdjustment() {
        return priceAdjustment;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public void setPriceAdjustment(String priceAdjustment) {
        this.priceAdjustment = priceAdjustment;
    }
    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public String getPriceAdjustmentDetail() {
        return priceAdjustmentDetail;
    }

    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public void setPriceAdjustmentDetail(String priceAdjustmentDetail) {
        this.priceAdjustmentDetail = priceAdjustmentDetail;
    }
    /**
     * 违约
     */
    public String getBreach() {
        return breach;
    }

    /**
     * 违约
     */
    public void setBreach(String breach) {
        this.breach = breach;
    }
    
    public String getAdvancePaymentInfo() {
        return advancePaymentInfo;
    }

    public void setAdvancePaymentInfo(String advancePaymentInfo) {
        this.advancePaymentInfo = advancePaymentInfo;
    }

    public String getPriceAdjustmentSecond() {
        return priceAdjustmentSecond;
    }

    public void setPriceAdjustmentSecond(String priceAdjustmentSecond) {
        this.priceAdjustmentSecond = priceAdjustmentSecond;
    }

    public String getPriceAdjustmentThird() {
        return priceAdjustmentThird;
    }

    public void setPriceAdjustmentThird(String priceAdjustmentThird) {
        this.priceAdjustmentThird = priceAdjustmentThird;
    }

    public String getPriceAdjustmentInfo() {
        return priceAdjustmentInfo;
    }

    public void setPriceAdjustmentInfo(String priceAdjustmentInfo) {
        this.priceAdjustmentInfo = priceAdjustmentInfo;
    }

    public String getPriceAdjustmentThirdTwo() {
        return priceAdjustmentThirdTwo;
    }

    public void setPriceAdjustmentThirdTwo(String priceAdjustmentThirdTwo) {
        this.priceAdjustmentThirdTwo = priceAdjustmentThirdTwo;
    }

    public String getPriceAdjustmentThirdThree() {
        return priceAdjustmentThirdThree;
    }

    public void setPriceAdjustmentThirdThree(String priceAdjustmentThirdThree) {
        this.priceAdjustmentThirdThree = priceAdjustmentThirdThree;
    }

    public String getOtherTerms() {
        return otherTerms;
    }

    public void setOtherTerms(String otherTerms) {
        this.otherTerms = otherTerms;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    /**
     * 承揽方式
     */
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }
}
