package com.ejianc.business.pro.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 结算报审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_settle_report")
public class SettleReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="start_date")
    private Date startDate; // 合同开工日期
    @TableField(value="end_date")
    private Date endDate; // 合同竣工日期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @TableField(value="contract_valuation_type")
    private String contractValuationType; // 合同计价形式
    @TableField(value="contract_promise_payment_rate")
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计实际完成产值(无税)
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计实际完成产值
    @TableField(value="sum_cost_mny")
    private BigDecimal sumCostMny; // 累计成本(无税)
    @TableField(value="sum_cost_tax_mny")
    private BigDecimal sumCostTaxMny; // 累计成本
    @TableField(value="sum_receipt_mny")
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    @TableField(value="sum_receipt_tax_mny")
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    @TableField(value="report_settle_mny")
    private BigDecimal reportSettleMny; // 报审结算金额
    @TableField(value="report_date")
    private Date reportDate; // 报审日期
    @TableField(value="subtract_tax_rate")
    private BigDecimal subtractTaxRate; // 合同约定审减率
    @TableField(value="predict_check_mny")
    private BigDecimal predictCheckMny; // 预计审定金额
    @TableField(value="predict_check_date")
    private Date predictCheckDate; // 预计审定日期
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 其中甲供材金额
    @TableField(value="check_unit")
    private String checkUnit; // 审核单位
    @TableField(value="settlement_type")
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="report_settle_tax_Mny")
    private BigDecimal reportSettleTaxMny; // 报审结算金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="actual_start_date")
    private Date actualStartDate; // 实际开工日期
    @TableField(value="actual_end_date")
    private Date actualEndDate; // 实际竣工日期
    @TableField(value="construction_unit")
    private String constructionUnit; // 建设单位
    @TableField(value="construction_unit_id")
    private Long constructionUnitId; // 建设单位
    @TableField(value="construction_scale")
    private String constructionScale; // 建设规模
    @TableField(value="target_responsibility_management_rate")
    private BigDecimal targetResponsibilityManagementRate; // 目标责任书确定上缴管理费率（%）
    @TableField(value="among_pay_group_management_rate")
    private BigDecimal amongPayGroupManagementRate; // 其中上缴集团管理费率（%）

    @TableField(value = "message_rec_employee_id")
    private Long messageRecEmployeeId; //消息接受人Id
    @TableField(value = "settle_stage")
    private String settleStage; // 结算阶段  固定值【第一阶段、第二阶段、第三阶段、第四阶段、第五阶段】
    @TableField(value = "unit_property")
    private String unitProperty; // 建设单位性质 1-集团内  2-集团外
    @TableField(value="contract_settle_rate")
    private BigDecimal contractSettleRate; //合同约定竣工结算支付比例
    @TableField(value="settle_condition")
    private String settleCondition; //竣工结算支付条件
    @TableField(value="sum_mny")
    private BigDecimal sumMny; //累计产值
    @TableField(value="sum_mny_tax")
    private BigDecimal sumMnyTax; //累计产值

    /**
     * 审批生效日期
     */
    @TableField(value = "effect_date")
    private Date effectDate;

    @TableField(exist=false)
    @SubEntity(serviceName="settleReportDetailService",pidName = "reportId")
    private List<SettleReportDetailEntity> unitProjectDetailList = new ArrayList<>(); // 单位工程明细

    public String getUnitProperty() {
        return unitProperty;
    }

    public void setUnitProperty(String unitProperty) {
        this.unitProperty = unitProperty;
    }

    public BigDecimal getContractSettleRate() {
        return contractSettleRate;
    }

    public void setContractSettleRate(BigDecimal contractSettleRate) {
        this.contractSettleRate = contractSettleRate;
    }

    public String getSettleCondition() {
        return settleCondition;
    }

    public void setSettleCondition(String settleCondition) {
        this.settleCondition = settleCondition;
    }

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }

    public BigDecimal getSumMnyTax() {
        return sumMnyTax;
    }

    public void setSumMnyTax(BigDecimal sumMnyTax) {
        this.sumMnyTax = sumMnyTax;
    }

    public Long getConstructionUnitId() {
        return constructionUnitId;
    }

    public void setConstructionUnitId(Long constructionUnitId) {
        this.constructionUnitId = constructionUnitId;
    }

    public String getSettleStage() {
        return settleStage;
    }

    public void setSettleStage(String settleStage) {
        this.settleStage = settleStage;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Long getMessageRecEmployeeId() {
        return messageRecEmployeeId;
    }

    public void setMessageRecEmployeeId(Long messageRecEmployeeId) {
        this.messageRecEmployeeId = messageRecEmployeeId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(String contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getPredictCheckMny() {
        return predictCheckMny;
    }

    public void setPredictCheckMny(BigDecimal predictCheckMny) {
        this.predictCheckMny = predictCheckMny;
    }
    public Date getPredictCheckDate() {
        return predictCheckDate;
    }

    public void setPredictCheckDate(Date predictCheckDate) {
        this.predictCheckDate = predictCheckDate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public List<SettleReportDetailEntity> getUnitProjectDetailList() {
        return unitProjectDetailList;
    }

    public void setUnitProjectDetailList(List<SettleReportDetailEntity> unitProjectDetailList) {
        this.unitProjectDetailList = unitProjectDetailList;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(String constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConstructionScale() {
        return constructionScale;
    }

    public void setConstructionScale(String constructionScale) {
        this.constructionScale = constructionScale;
    }

    public BigDecimal getTargetResponsibilityManagementRate() {
        return targetResponsibilityManagementRate;
    }

    public void setTargetResponsibilityManagementRate(BigDecimal targetResponsibilityManagementRate) {
        this.targetResponsibilityManagementRate = targetResponsibilityManagementRate;
    }

    public BigDecimal getAmongPayGroupManagementRate() {
        return amongPayGroupManagementRate;
    }

    public void setAmongPayGroupManagementRate(BigDecimal amongPayGroupManagementRate) {
        this.amongPayGroupManagementRate = amongPayGroupManagementRate;
    }
}
