package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.SettlementFinalizationDetailEntity;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.ISettlementFinalizationDetailService;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettlementFinalizationDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.income.bean.SettlementFinalizationEntity;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;
import com.ejianc.business.pro.income.vo.SettlementFinalizationVO;

/**
 * 工程结算定案表返回确认单主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlementFinalization")
public class SettlementFinalizationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SETTLEMENT_FINALIZATION";//此处需要根据实际修改

    @Autowired
    private ISettlementFinalizationService service;
    @Autowired
    private ISettlementFinalizationDetailService settlementFinalizationDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> saveOrUpdate(@RequestBody SettlementFinalizationVO saveOrUpdateVO) {
        SettlementFinalizationVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 根据项目id、单据id查询工程结算定案单数据
     * @param projectId
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettleFinalization", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> querySettleFinalization(@RequestParam(required = false) Long projectId, @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.querySettleFinalization(projectId, id));
    }
    /**
     * 根据项目id 结算阶段查询项目信息
     * @param projectId
     * @param id
     * @return
     */
    @RequestMapping(value = "/getDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementFinalizationDetailVO> getDataByProjectId(@RequestParam(required = false) Long id, @RequestParam Long projectId, @RequestParam Long childProjectId, @RequestParam String settleStage) {
        SettlementFinalizationDetailVO settlementFinalizationDetailVO = service.getDataByProjectId(id,projectId,childProjectId, settleStage);
        return CommonResponse.success("查询数据成功！", settlementFinalizationDetailVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> queryDetail(Long id) {
        SettlementFinalizationVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/updateDateById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> updateDateById(@RequestBody SettlementFinalizationVO settlementFinalizationVO) {
        SettlementFinalizationEntity settlementFinalizationEntity = service.selectById(settlementFinalizationVO.getId());
        settlementFinalizationEntity.setFinalizationBackDate(settlementFinalizationVO.getFinalizationBackDate());
        service.updateById(settlementFinalizationEntity);
        return CommonResponse.success("更新成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementFinalizationVO> vos) {
        service.removeByIds(vos.stream().map(SettlementFinalizationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementFinalizationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("constructName");
        param.getFuzzyFields().add("checkUnit");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("createTime") ? param.getOrderMap().get("createTime") : QueryParam.DESC);

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }

        IPage<SettlementFinalizationEntity> page = service.queryPage(param,false);
        IPage<SettlementFinalizationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SettlementFinalizationVO> settlementFinalizationVOS = BeanMapper.mapList(page.getRecords(), SettlementFinalizationVO.class);
//        List<SettlementFinalizationVO> finalizationVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(settlementFinalizationVOS)){
            List<Long> ids = settlementFinalizationVOS.stream().map(SettlementFinalizationVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<SettlementFinalizationDetailEntity> lambdaFinalizationDetail = Wrappers.<SettlementFinalizationDetailEntity>lambdaQuery();
            lambdaFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List<SettlementFinalizationDetailEntity> settlementFinalizationDetailEntities = settlementFinalizationDetailService.list(lambdaFinalizationDetail);
            Map<Long, List<SettlementFinalizationDetailEntity>> mapChild = new HashMap<>();
            Map<Long, List<SettlementFinalizationDetailEntity>> mapSun = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() != null).collect(
                    Collectors.groupingBy(score -> score.getParentId()));
            if(CollectionUtils.isNotEmpty(settlementFinalizationDetailEntities)){
                mapChild = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() == null).collect(
                        Collectors.groupingBy(score -> score.getFinalizationId()));
            }

            for (SettlementFinalizationVO settlementFinalizationVO : settlementFinalizationVOS){
//                finalizationVOList.add(settlementFinalizationVO);
                logger.info("111");
                if (mapChild.containsKey(settlementFinalizationVO.getId())){
                    logger.info("222");
                    List<SettlementFinalizationDetailEntity> childList = mapChild.get(settlementFinalizationVO.getId());

                    List<SettlementFinalizationVO> settleChild = new ArrayList<>();
                    for (SettlementFinalizationDetailEntity settlementFinalizationDetailEntity : childList){
                        logger.info("333");
                        SettlementFinalizationVO settlementFinalizationChild = new SettlementFinalizationVO();
                        settlementFinalizationChild.setSumFinalizationBackMny(settlementFinalizationDetailEntity.getFinalizationBackMny());
                        settlementFinalizationChild.setSumFinalizationOutMny(settlementFinalizationDetailEntity.getFinalizationOutMny());
                        settlementFinalizationChild.setId(IdWorker.getId());
                        settlementFinalizationChild.setProjectName(settlementFinalizationDetailEntity.getChildProjectName());
                        settlementFinalizationChild.setBasicUnitName(settlementFinalizationDetailEntity.getBasicUnitName());
                        settlementFinalizationChild.setBillState(settlementFinalizationVO.getBillState());
                        settleChild.add(settlementFinalizationChild);
//                        finalizationVOList.add(settlementFinalizationChild);
                        if (mapSun.containsKey(settlementFinalizationDetailEntity.getId())){
                            logger.info("444");
                            List<SettlementFinalizationVO> settleSun = new ArrayList<>();
                            List<SettlementFinalizationDetailEntity> sunList = mapSun.get(settlementFinalizationDetailEntity.getId());
                            for (SettlementFinalizationDetailEntity settlementFinalizationDetailSun : sunList){
                                SettlementFinalizationVO settlementFinalizationSun = new SettlementFinalizationVO();
                                settlementFinalizationSun.setSumFinalizationBackMny(settlementFinalizationDetailSun.getFinalizationBackMny());
                                settlementFinalizationSun.setSumFinalizationOutMny(settlementFinalizationDetailSun.getFinalizationOutMny());
                                settlementFinalizationSun.setId(IdWorker.getId());
                                settlementFinalizationSun.setBasicUnitName(settlementFinalizationDetailSun.getBasicUnitName());
                                settleSun.add(settlementFinalizationSun);
//                                finalizationVOList.add(settlementFinalizationSun);
                            }
                            settlementFinalizationChild.setChildren(settleSun);
                        }
                        settleChild.add(settlementFinalizationChild);
                    }
                    settlementFinalizationVO.setChildren(settleChild);
                }
            }
        }

        pageData.setRecords(settlementFinalizationVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("constructName");
        param.getFuzzyFields().add("checkUnit");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("createTime") ? param.getOrderMap().get("createTime") : QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        List<SettlementFinalizationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<SettlementFinalizationVO> voList = BeanMapper.mapList(list, SettlementFinalizationVO.class);
        voList.forEach(e -> {
            if(e.getFinalizationFormFlag() != null){
                if(e.getFinalizationFormFlag() == 1){
                    e.setFinalizationFormFlagName("是");
                }else{
                    e.setFinalizationFormFlagName("否");
                }
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });

        List<SettlementFinalizationVO> finalizationVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(voList)){
            List<Long> ids = voList.stream().map(SettlementFinalizationVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<SettlementFinalizationDetailEntity> lambdaFinalizationDetail = Wrappers.<SettlementFinalizationDetailEntity>lambdaQuery();
            lambdaFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List<SettlementFinalizationDetailEntity> settlementFinalizationDetailEntities = settlementFinalizationDetailService.list(lambdaFinalizationDetail);
            Map<Long, List<SettlementFinalizationDetailEntity>> mapChild = new HashMap<>();
            if(CollectionUtils.isNotEmpty(settlementFinalizationDetailEntities)){
                mapChild = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() == null).collect(
                        Collectors.groupingBy(score -> score.getFinalizationId()));
            }
            Map<Long, List<SettlementFinalizationDetailEntity>> mapSun = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() != null).collect(
                    Collectors.groupingBy(score -> score.getParentId()));

            for (SettlementFinalizationVO settlementFinalizationVO : voList){
                finalizationVOList.add(settlementFinalizationVO);
                logger.info("111");
                if (mapChild.containsKey(settlementFinalizationVO.getId())){
                    logger.info("222");
                    List<SettlementFinalizationDetailEntity> childList = mapChild.get(settlementFinalizationVO.getId());

                    List<SettlementFinalizationVO> settleChild = new ArrayList<>();
                    for (SettlementFinalizationDetailEntity settlementFinalizationDetailEntity : childList){
                        logger.info("333");
                        SettlementFinalizationVO settlementFinalizationChild = new SettlementFinalizationVO();
                        settlementFinalizationChild.setSumFinalizationBackMny(settlementFinalizationDetailEntity.getFinalizationBackMny());
                        settlementFinalizationChild.setSumFinalizationOutMny(settlementFinalizationDetailEntity.getFinalizationOutMny());
                        settlementFinalizationChild.setId(IdWorker.getId());
                        settlementFinalizationChild.setProjectName(settlementFinalizationDetailEntity.getChildProjectName());
                        settlementFinalizationChild.setBasicUnitName(settlementFinalizationDetailEntity.getBasicUnitName());
                        settlementFinalizationChild.setBillState(settlementFinalizationVO.getBillState());
                        settleChild.add(settlementFinalizationChild);
                        finalizationVOList.add(settlementFinalizationChild);

                        if (mapSun.containsKey(settlementFinalizationDetailEntity.getId())){
                            List<SettlementFinalizationVO> settleSun = new ArrayList<>();
                            List<SettlementFinalizationDetailEntity> sunList = mapSun.get(settlementFinalizationDetailEntity.getId());
                            for (SettlementFinalizationDetailEntity settlementFinalizationDetailSun : sunList){
                                SettlementFinalizationVO settlementFinalizationSun = new SettlementFinalizationVO();
                                settlementFinalizationSun.setSumFinalizationBackMny(settlementFinalizationDetailSun.getFinalizationBackMny());
                                settlementFinalizationSun.setSumFinalizationOutMny(settlementFinalizationDetailSun.getFinalizationOutMny());
                                settlementFinalizationSun.setId(IdWorker.getId());
                                settlementFinalizationSun.setBasicUnitName(settlementFinalizationDetailSun.getBasicUnitName());
                                settleSun.add(settlementFinalizationSun);
                                finalizationVOList.add(settlementFinalizationSun);

                            }
                            settlementFinalizationChild.setChildren(settleSun);
                        }
                        settleChild.add(settlementFinalizationChild);
                    }
                    settlementFinalizationVO.setChildren(settleChild);
                }
            }
        }

        for (SettlementFinalizationVO vo : finalizationVOList) {
            if (vo.getBillState() != null) {
                vo.setBillStateName(com.ejianc.business.pro.income.enums.BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.一审.getCode())) {
                vo.setFinalizationStageName("一审");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.二审.getCode())) {
                vo.setFinalizationStageName("二审");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.三审.getCode())) {
                vo.setFinalizationStageName("三审");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.终审.getCode())) {
                vo.setFinalizationStageName("终审");
            }
            //结算阶段  settleStage
            if ("1".equals(vo.getSettleStage())) {
                vo.setSettleStage("第一阶段");
            }
            if ("2".equals(vo.getSettleStage())) {
                vo.setSettleStage("第二阶段");
            }
            if ("3".equals(vo.getSettleStage())) {
                vo.setSettleStage("第三阶段");
            }
            if ("4".equals(vo.getSettleStage())) {
                vo.setSettleStage("第四阶段");
            }
            if ("5".equals(vo.getSettleStage())) {
                vo.setSettleStage("第五阶段");
            }
            //建设单位性质  unitProperty
            if ("1".equals(vo.getUnitProperty())) {
                vo.setUnitProperty("集团内");
            }
            if ("2".equals(vo.getUnitProperty())) {
                vo.setUnitProperty("集团外");
            }
        }
        beans.put("records", finalizationVOList);
        ExcelExport.getInstance().export("settlementFinalization-export.xlsx", beans, response);
    }

}
