package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.UnsettleDetailEntity;
import com.ejianc.business.pro.income.bean.UnsettleEntity;
import com.ejianc.business.pro.income.service.IUnsettleDetailService;
import com.ejianc.business.pro.income.service.IUnsettleService;
import com.ejianc.business.pro.income.vo.UnsettleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.income.bean.UnsettleDisputedEntity;
import com.ejianc.business.pro.income.service.IUnsettleDisputedService;
import com.ejianc.business.pro.income.vo.UnsettleDisputedVO;

/**
 * 争议事项推进
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unsettleDisputed")
public class UnsettleDisputedController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IUnsettleDisputedService service;

    @Autowired
    private IUnsettleService unsettleService;

    @Autowired
    private IUnsettleDetailService unsettleDetailService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody List<UnsettleDisputedVO> saveOrUpdateVOs) {
        if(CollectionUtils.isNotEmpty(saveOrUpdateVOs)){
            List<UnsettleDisputedVO> saveVOList = new ArrayList<>();
            List<Long> delVOList = new ArrayList<>();
            saveOrUpdateVOs.forEach(e->{
                if(null!=e.getRowState()&&"del".equals(e.getRowState())){
                    delVOList.add(e.getId());
                }else{
                    saveVOList.add(e);
                }
            });
            if(CollectionUtils.isNotEmpty(saveVOList)){
                service.saveOrUpdateBatch(BeanMapper.mapList(saveVOList,UnsettleDisputedEntity.class));
            }
            if(CollectionUtils.isNotEmpty(delVOList)){
                service.removeByIds(delVOList);
            }
            BigDecimal detailDisputedMny = saveVOList.stream().filter(item -> null != item.getAllDisputedMny()).map(UnsettleDisputedVO::getAllDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);

            //更新子表明细 里的争议金额
            LambdaUpdateWrapper<UnsettleDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(UnsettleDetailEntity::getUnsettleId, saveOrUpdateVOs.get(0).getUnsettleId());
            updateWrapper.eq(UnsettleDetailEntity::getProjectId,saveOrUpdateVOs.get(0).getProjectId());
            updateWrapper.set(UnsettleDetailEntity::getDetailDisputedMny, detailDisputedMny);
            unsettleDetailService.update(updateWrapper);
            //汇总子表的 累计已解决争议金额   和 争议金额
            LambdaQueryWrapper<UnsettleDisputedEntity> lambda = Wrappers.<UnsettleDisputedEntity>lambdaQuery();
            lambda.eq(UnsettleDisputedEntity::getUnsettleId,saveOrUpdateVOs.get(0).getUnsettleId());
//            lambda.eq(UnsettleDisputedEntity::getProjectId,saveOrUpdateVOs.get(0).getProjectId());
            List<UnsettleDisputedEntity> unsettleDisputedEntityList = service.list(lambda);
            if(CollectionUtils.isNotEmpty(unsettleDisputedEntityList)){
                //累计已解决争议金额
                BigDecimal resolvedDisputedMny = unsettleDisputedEntityList.stream().filter(item -> null != item.getResolvedDisputedMny()).map(UnsettleDisputedEntity::getResolvedDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                //争议金额 合计
                BigDecimal allDisputedMny = unsettleDisputedEntityList.stream().filter(item -> null != item.getAllDisputedMny()).map(UnsettleDisputedEntity::getAllDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                LambdaUpdateWrapper<UnsettleEntity> updateWrapperh = new LambdaUpdateWrapper<>();
                updateWrapperh.in(UnsettleEntity::getId, saveOrUpdateVOs.get(0).getUnsettleId());
                updateWrapperh.set(UnsettleEntity::getDisputedMny, allDisputedMny);
                updateWrapperh.set(UnsettleEntity::getSumDisputedMny, resolvedDisputedMny);
                unsettleService.update(updateWrapperh);
            }

        }
        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnsettleDisputedVO> queryDetail(Long id) {
    	UnsettleDisputedEntity entity = service.selectById(id);
    	UnsettleDisputedVO vo = BeanMapper.map(entity, UnsettleDisputedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryDetailList 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UnsettleDisputedVO>> queryDetailList(Long unsettleId,Long projectId) {
        LambdaQueryWrapper<UnsettleDisputedEntity> lambda = Wrappers.<UnsettleDisputedEntity>lambdaQuery();
        lambda.eq(UnsettleDisputedEntity::getUnsettleId,unsettleId);
        lambda.eq(UnsettleDisputedEntity::getProjectId,projectId);
        List<UnsettleDisputedEntity> contractRegisterList = service.list(lambda);
        if(CollectionUtils.isNotEmpty(contractRegisterList)){
            return CommonResponse.success("查询详情数据成功！",BeanMapper.mapList(contractRegisterList,UnsettleDisputedVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！",new ArrayList<>());
        }

    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnsettleDisputedVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (UnsettleDisputedVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UnsettleDisputedVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnsettleDisputedVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<UnsettleDisputedEntity> page = service.queryPage(param,false);
        IPage<UnsettleDisputedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnsettleDisputedVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnsettleDisputedEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("UnsettleDisputed-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refUnsettleDisputedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnsettleDisputedVO>> refUnsettleDisputedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnsettleDisputedEntity> page = service.queryPage(param,false);
        IPage<UnsettleDisputedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnsettleDisputedVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
