package com.ejianc.business.pro.income.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 预算来源
 */
public enum BudgetEnum {
    CONTRACT(0, "中标预算"),
    CHANGE(1, "变更"),
    VISA(2, "签证"),
    CLAIM(3, "索赔"),
    BUDGET(4, "施工图预算"),
    OTHER(5, "其它"),
    GCZJ(6, "工程造价调整"),
    YS(7, "结算预算");

    private final Integer code;
    private final String name;

    private static Map<Integer, BudgetEnum> enumMap = new HashMap<>();

    BudgetEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }
    public String getName() {
        return name;
    }

    static {
        enumMap = (Map)EnumSet.allOf(BudgetEnum.class).stream().collect(Collectors.toMap(BudgetEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

    public static BudgetEnum getEnumByStateCode(Integer code) {
        return (BudgetEnum)enumMap.get(code);
    }
}
