/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.QuoteHistoryVO;
import com.ejianc.business.pro.income.vo.QuoteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"quote"})
public class QuoteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IQuoteService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuoteVO> saveOrUpdate(@RequestBody QuoteVO saveorUpdateVO) {
        QuoteVO vo = this.service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryApproveMnyByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteVO> queryApproveMnyByContractId(Long contractId) {
        QuoteVO quoteVO = this.service.queryApproveMnyByContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)quoteVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteVO> queryDetail(Long id) {
        QuoteVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? (String)param.getOrderMap().get("quoteDate") : "desc");
        if (null == param.getParams().get("parentOrgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        List quoteVO = BeanMapper.mapList((Iterable)page.getRecords(), QuoteVO.class);
        Date now = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        for (QuoteVO vo : quoteVO) {
            if (!BillStateEnum.PASSED_STATE.getBillStateCode().equals(vo.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(vo.getBillState()) || vo.getReplyStatus() != 0 || null == vo.getCommitDate() || DateUtils.addDays((Date)vo.getCommitDate(), (int)30).compareTo(now) != -1) continue;
            vo.setReplyStatusRedFlag(Integer.valueOf(1));
            this.logger.info("\u53ef\u4ee5\u4e86");
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(quoteVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? (String)param.getOrderMap().get("quoteDate") : "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, QuoteVO.class);
        voList.forEach(e -> {
            if (e.getProductionContain() != null) {
                if (e.getProductionContain() == 1) {
                    e.setProductionContainName("\u662f");
                } else {
                    e.setProductionContainName("\u5426");
                }
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuoteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> refQuoteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        param.getParams().put("reply_status", new Parameter("eq", (Object)1));
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("bill_state", new Parameter("in", billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), QuoteVO.class);
        ArrayList voList = new ArrayList();
        vos.forEach(e -> {
            e.setResidueTaxMny(MathUtil.safeSub(e.getReplyTaxMny(), e.getAppliedTaxMny()));
            if (e.getResidueTaxMny().compareTo(BigDecimal.ZERO) == 1) {
                voList.add(e);
            }
        });
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(Long id) {
        String msg = this.service.validateContract(id);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/calculateSumCheckProduction"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> calculateSumCheckProduction(Long contractId) {
        BigDecimal sumCheckProduction = this.service.calculateSumCheckProduction(contractId);
        return CommonResponse.success((String)"\u8ba1\u7b97\u5408\u540c\u7d2f\u8ba1\u6279\u590d\u91d1\u989d\u6210\u529f\uff01", (Object)sumCheckProduction);
    }

    @RequestMapping(value={"/calculateSumProduction"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> calculateSumProduction(Long contractId) {
        Map<String, BigDecimal> sumProductionMap = this.service.calculateSumProduction(contractId);
        this.logger.info("\u83b7\u5f97\u7d2f\u8ba1\u5ba1\u5b9a\u4ea7\u503c\uff1a{}", (Object)JSONObject.toJSONString(sumProductionMap));
        return CommonResponse.success((String)"\u8ba1\u7b97\u5408\u540c\u7d2f\u8ba1\u6279\u590d\u91d1\u989d\u6210\u529f\uff01", sumProductionMap);
    }

    @RequestMapping(value={"/queryQuoteHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteHistoryVO> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVO vo = this.service.queryQuoteHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"saveReply"})
    @ResponseBody
    public CommonResponse<String> saveReply(@RequestBody QuoteVO vo) {
        QuoteEntity entity = (QuoteEntity)((Object)this.service.selectById(vo.getId()));
        if (entity != null) {
            boolean pool;
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)vo.getId());
            wrapper.set(QuoteEntity::getReplyDate, (Object)vo.getReplyDate());
            wrapper.set(QuoteEntity::getReplyStatus, (Object)vo.getReplyStatus());
            wrapper.set(QuoteEntity::getReplyMny, (Object)vo.getReplyMny());
            wrapper.set(QuoteEntity::getReplyTaxMny, (Object)vo.getReplyTaxMny());
            BigDecimal sumCheckProductionNew = BigDecimal.ZERO;
            if (new Integer(1).equals(vo.getReplyStatus())) {
                BigDecimal sumCheckProduction = this.service.calculateSumCheck(entity.getContractId(), vo.getId());
                wrapper.set(QuoteEntity::getSumCheckProduction, (Object)(sumCheckProduction != null ? sumCheckProduction.add(vo.getReplyTaxMny()) : vo.getReplyTaxMny()));
                sumCheckProductionNew = sumCheckProduction != null ? sumCheckProduction.add(vo.getReplyTaxMny()) : vo.getReplyTaxMny();
            }
            wrapper.set(QuoteEntity::getDiffMny, (Object)ComputeUtil.safeSub((BigDecimal)sumCheckProductionNew, (BigDecimal)entity.getSumActualMnyTax()));
            this.service.update((Wrapper)wrapper);
            entity = (QuoteEntity)((Object)this.service.selectById(vo.getId()));
            if (new Integer(1).equals(vo.getReplyStatus()) && !(pool = this.service.pushSettleToPool((QuoteVO)BeanMapper.map((Object)((Object)entity), QuoteVO.class)))) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.service.selectById(id));
        QuoteVO vo = (QuoteVO)BeanMapper.map((Object)((Object)quoteEntity), QuoteVO.class);
        if (new Integer(1).equals(vo.getReplyStatus())) {
            boolean pool = this.service.pushSettleToPool(vo);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        } else {
            return CommonResponse.success((String)"\u65e0\u9700\u63a8\u9001\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)true);
    }
}

