/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegister")
public class ContractRegisterBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractRegisterService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u5f00\u59cb");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        wrapper.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)wrapper);
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u7ed3\u675f");
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        boolean pushResult = this.service.pushContract((ContractRegisterVO)BeanMapper.map((Object)((Object)contractEntity), ContractRegisterVO.class), false);
        if (pushResult) {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.service.saveOrUpdate((Object)contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        if (entity.getSupplementFlag() == 1) {
            return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            wrapper.eq(BaseEntity::getId, (Object)billId);
            boolean delResult = this.service.delContractFromPool(billId);
            if (delResult) {
                wrapper.set(ContractRegisterEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                this.service.update((Wrapper)wrapper);
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

