/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"finalized"})
public class FinalizedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinalizedService service;
    @Autowired
    private IContractRegisterService registerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)entity), FinalizedVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List contractIds;
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BaseEntity::getId, ids);
        List list = this.service.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list) && ListUtil.isNotEmpty(contractIds = list.stream().filter(e -> e.getFinalStage().equals(FinalStageEnum.\u7ec8\u5ba1.getCode())).map(FinalizedEntity::getContractId).collect(Collectors.toList()))) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractRegisterEntity::getIsFinish, (Object)0);
            updateWrapper.set(ContractRegisterEntity::getContractStatus, (Object)1);
            updateWrapper.in(BaseEntity::getId, contractIds);
            this.registerService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, FinalizedVO.class);
        for (FinalizedVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e00\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e00\u5ba1");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e8c\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e8c\u5ba1");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e09\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e09\u5ba1");
            }
            if (!Objects.equals(vo.getFinalStage(), FinalStageEnum.\u7ec8\u5ba1.getCode())) continue;
            vo.setFinalStageName("\u7ec8\u5ba1");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFinalizedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySettleReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required=false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.querySettleReport(projectId, contractId));
    }

    @RequestMapping(value={"/queryFinalizedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedList(projectId, contractId, id));
    }

    @RequestMapping(value={"/validateFinalStage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    @RequestMapping(value={"/queryFinalizedRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedRecord(id));
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        FinalizedEntity finalizedEntity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)finalizedEntity), FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())) {
            boolean pool = this.service.pushSettleToPool(vo);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        } else {
            return CommonResponse.success((String)"\u65e0\u9700\u63a8\u9001\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)true);
    }
}

