/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"finalized"})
public class FinalizedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinalizedService service;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IContractRegisterService contractRegisterService;

    @GetMapping(value={"contractByProject"})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> contractByProject(@RequestParam Long projectId) {
        ContractRegisterVO resp = null;
        List<ContractRegisterVO> contractList = this.contractRegisterService.getAllValidConsByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(contractList)) {
            for (ContractRegisterVO con : contractList) {
                if (null == resp) {
                    resp = con;
                    continue;
                }
                resp.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)resp.getContractTaxMny(), (BigDecimal)con.getContractTaxMny()));
                resp.setContractMny(ComputeUtil.safeAdd((BigDecimal)resp.getContractMny(), (BigDecimal)con.getContractMny()));
            }
        }
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {
        List list;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)saveOrUpdateVO.getProjectId());
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)query)))) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728\u7ae3\u5de5\u7ed3\u7b97\u5355\uff01");
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)entity), FinalizedVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
        for (FinalizedVO f : pageData.getRecords()) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
                Integer days;
                if ("0".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("\u672a\u62a5\u9001" + (days > 60 ? "(\u5df2\u8d85" + (days - 60) + "\u5929)" : ""));
                    continue;
                }
                if ("1".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("\u4e00\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                    continue;
                }
                if ("2".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getFinalInstanceDate());
                    f.setFinalStageName("\u7ec8\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                    continue;
                }
                f.setFinalStageName("\u7ec8\u5ba1\u5b8c\u6210");
                continue;
            }
            f.setFinalStageName("\u672a\u62a5\u9001");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, FinalizedVO.class);
        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
        for (FinalizedVO f : voList) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
                Integer days;
                if ("0".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("\u672a\u62a5\u9001" + (days > 60 ? "(\u5df2\u8d85" + (days - 60) + "\u5929)" : ""));
                } else if ("1".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("\u4e00\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                } else if ("2".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getFinalInstanceDate());
                    f.setFinalStageName("\u7ec8\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                } else {
                    f.setFinalStageName("\u7ec8\u5ba1\u5b8c\u6210");
                }
            } else {
                f.setFinalStageName("\u672a\u62a5\u9001");
            }
            f.setBillStateName(BillStateEnum.getEnumByStateCode(f.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFinalizedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySettleReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required=false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.querySettleReport(projectId, contractId));
    }

    @RequestMapping(value={"/queryFinalizedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedList(projectId, contractId, id));
    }

    @RequestMapping(value={"/validateFinalStage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    @RequestMapping(value={"/queryFinalizedRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedRecord(id));
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        FinalizedEntity finalizedEntity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)finalizedEntity), FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())) {
            boolean pool = this.service.pushSettleToPool(vo);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        } else {
            return CommonResponse.success((String)"\u65e0\u9700\u63a8\u9001\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)true);
    }
}

