/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailCostEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailFeeEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailMeasureEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailOtherEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailSubEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.enums.FinancialCrossEnum;
import com.ejianc.business.pro.income.mapper.QuoteMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IQuoteDetailService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.utils.DetailListUtil;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.utils.TreeSortUtil;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.QuoteDetailVO;
import com.ejianc.business.pro.income.vo.QuoteHistoryVO;
import com.ejianc.business.pro.income.vo.QuoteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="quoteService")
public class QuoteServiceImpl
extends BaseServiceImpl<QuoteMapper, QuoteEntity>
implements IQuoteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRO_INCOME_QUOTE";
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private DetailListUtil detailListUtil;
    @Autowired
    private IQuoteDetailService detailService;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IProductionService productionService;

    @Override
    public QuoteVO saveOrUpdate(QuoteVO saveorUpdateVO) {
        this.validateProjectOrPeriod(saveorUpdateVO.getProjectId(), saveorUpdateVO.getId(), saveorUpdateVO.getQuotePeriod());
        QuoteEntity entity = (QuoteEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, QuoteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        List<QuoteDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (QuoteDetailEntity detail : detailList) {
                detail.setQuoteId(entity.getId());
                if ("del".equals(detail.getRowState())) {
                    this.detailService.removeById(detail.getId(), false);
                    continue;
                }
                this.detailService.saveOrUpdate((Object)detail, false);
                this.dealParentId(detail);
                this.detailService.saveOrUpdate((Object)detail, false);
            }
        }
        List<Long> claimIds = entity.getClaimList().stream().filter(x -> !"del".equals(x.getRowState())).map(x -> x.getClaimId()).collect(Collectors.toList());
        this.productionService.updateClaimsUseFlag(claimIds, true);
        List<Long> productIds = entity.getProductionList().stream().filter(x -> !"del".equals(x.getRowState())).map(x -> x.getProductionId()).collect(Collectors.toList());
        this.productionService.updateProductsUseFlag(productIds, entity.getId(), true);
        return this.queryDetail(entity.getId());
    }

    private void dealParentId(QuoteDetailEntity detail) {
        List<QuoteDetailFeeEntity> feeList;
        List<QuoteDetailOtherEntity> otherList;
        List<QuoteDetailMeasureEntity> measureList;
        List<QuoteDetailSubEntity> subList;
        List<QuoteDetailCostEntity> costList = detail.getCostList();
        if (CollectionUtils.isNotEmpty(costList)) {
            HashMap idMap = new HashMap();
            costList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            costList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(subList = detail.getSubList())) {
            HashMap idMap = new HashMap();
            subList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            subList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(measureList = detail.getMeasureList())) {
            HashMap idMap = new HashMap();
            measureList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            measureList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherList = detail.getOtherList())) {
            HashMap idMap = new HashMap();
            otherList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            otherList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(feeList = detail.getFeeList())) {
            HashMap idMap = new HashMap();
            feeList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            feeList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
    }

    @Override
    public QuoteVO queryDetail(Long id) {
        List detailList;
        QuoteEntity entity = (QuoteEntity)((Object)super.selectById((Serializable)id));
        this.detailListUtil.setDetailList(entity.getDetailList());
        QuoteVO vo = (QuoteVO)BeanMapper.map((Object)((Object)entity), QuoteVO.class);
        if (entity != null && CollectionUtils.isNotEmpty((Collection)(detailList = vo.getDetailList()))) {
            for (QuoteDetailVO detail : detailList) {
                List feeList;
                List otherList;
                List measureList;
                List subList;
                List costList = detail.getCostList();
                if (CollectionUtils.isNotEmpty((Collection)costList)) {
                    costList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(costList);
                    detail.setCostList(TreeNodeBUtil.buildTree((List)costList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(subList = detail.getSubList()))) {
                    subList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(subList);
                    detail.setSubList(TreeNodeBUtil.buildTree((List)subList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(measureList = detail.getMeasureList()))) {
                    measureList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(measureList);
                    detail.setMeasureList(TreeNodeBUtil.buildTree((List)measureList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(otherList = detail.getOtherList()))) {
                    otherList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(otherList);
                    detail.setOtherList(TreeNodeBUtil.buildTree((List)otherList));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(feeList = detail.getFeeList()))) continue;
                feeList.forEach(i -> {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                    i.setShadowId(i.getTid());
                    i.setRowState("edit");
                });
                new TreeSortUtil().entryListToSort(feeList);
                detail.setFeeList(TreeNodeBUtil.buildTree((List)feeList));
            }
        }
        return vo;
    }

    @Override
    public String validateContract(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5bf9\u7532\u62a5\u91cf\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public QuoteHistoryVO queryQuoteHistory(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        QuoteHistoryVO vo = new QuoteHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("quoteDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        List list = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return vo;
        }
        BigDecimal sumQuoteMny = list.stream().map(QuoteEntity::getQuoteMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumQuoteTaxMny = list.stream().map(QuoteEntity::getQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReplyMny = list.stream().filter(e -> e.getReplyMny() != null).map(QuoteEntity::getReplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReplyTaxMny = list.stream().filter(e -> e.getReplyTaxMny() != null).map(QuoteEntity::getReplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumQuoteMny(sumQuoteMny);
        vo.setSumQuoteTaxMny(sumQuoteTaxMny);
        vo.setSumReplyMny(sumReplyMny);
        vo.setSumReplyTaxMny(sumReplyTaxMny);
        vo.setQuoteRecord(BeanMapper.mapList((Iterable)list, QuoteVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(QuoteVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public void uploadFinancial(Long id) {
        QuoteEntity quote = (QuoteEntity)((Object)super.selectById((Serializable)id));
        quote.setFinancialCrossFlag(FinancialCrossEnum.\u5df2\u4f20\u4f1a\u8ba1\u5e73\u53f0.getCode());
        super.saveOrUpdate((Object)quote, false);
    }

    @Override
    public String validateProjectOrPeriod(Long projectId, Long id, String period) {
        List list;
        List freeList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty(freeList = (list = super.queryList(queryParam, false)).stream().filter(x -> 1 != x.getBillState() && 3 != x.getBillState()).collect(Collectors.toList()))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u7684\u8ba1\u91cf\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        if (StringUtils.isNotEmpty((CharSequence)period) && CollectionUtils.isNotEmpty((Collection)list)) {
            Date minStart = list.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getQuotePeriod())).map(x -> DateUtil.parseDate(StringUtils.split((String)x.getQuotePeriod(), (String)"~")[0])).min(DateUtil::compareDay).orElse(null);
            Date maxEnd = list.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getQuotePeriod())).map(x -> DateUtil.parseDate(StringUtils.split((String)x.getQuotePeriod(), (String)"~")[1])).max(DateUtil::compareDay).orElse(null);
            Date start = DateUtil.parseDate(StringUtils.split((String)period, (String)"~")[0]);
            Date end = DateUtil.parseDate(StringUtils.split((String)period, (String)"~")[1]);
            if (DateUtil.compareDay(start, maxEnd) <= 0 || DateUtil.compareDay(end, minStart) >= 0) {
                this.logger.error("period-{}--minStart-{}--maxEnd-{}", new Object[]{period, minStart, maxEnd});
                throw new BusinessException("\u8be5\u9879\u76ee\u8be5\u4ea7\u503c\u533a\u95f4\u5df2\u5b58\u5728\u62a5\u91cf\u5355\uff01");
            }
        }
        return "\u6821\u9a8c\u6210\u529f\uff01";
    }

    private void convertSettleVOToSettlePoolVO(QuoteVO vo, SettlePoolVO spv) {
        spv.setSourceType("product_value_first");
        spv.setSourceId(vo.getId());
        spv.setId(vo.getId());
        spv.setSettleProperty(Integer.valueOf(1));
        spv.setUltimateFlag(Integer.valueOf(0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setCurTax(ComputeUtil.safeSub((BigDecimal)vo.getReplyTaxMny(), (BigDecimal)vo.getReplyMny()));
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/quote/card?id=" + vo.getId());
        spv.setContractFlag(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(vo.getContractId()));
            spv.setContractType("contraction");
            spv.setContractFlag(Integer.valueOf(1));
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setPartybId(contractEntity.getSupplierId());
            spv.setPartybName(contractEntity.getSupplierName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(QuoteEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(QuoteEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (QuoteEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getReplyTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getReplyTaxMny();
                    BigDecimal settMny = settlementEntity.getReplyMny() == null ? BigDecimal.ZERO : settlementEntity.getReplyMny();
                    BigDecimal settTax = ComputeUtil.safeSub((BigDecimal)settTaxMny, (BigDecimal)settMny);
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210");
    }
}

