/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.utils;

import com.ejianc.framework.core.kit.base.annotation.NotNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static final String CURRENT_YEAR = DateUtil.getCurrentYear();

    public static Integer getSubDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time1 - time2) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Integer days = Integer.parseInt(String.valueOf(betweenDays));
        return days < 0 ? days - 1 : days + 1;
    }

    public static int compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int compareDay(Date dt1, Date dt2) {
        dt1 = DateUtil.parseDate(DateUtil.formatDate(dt1));
        dt2 = DateUtil.parseDate(DateUtil.formatDate(dt2));
        return DateUtil.compareDate(dt1, dt2);
    }

    public static Date maxDate(Date date1, Date date2, Boolean flag) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (flag.booleanValue()) {
            if (DateUtil.compareDate(date1, date2) < 0) {
                return date2;
            }
            return date1;
        }
        if (DateUtil.compareDate(date1, date2) < 0) {
            return date1;
        }
        return date2;
    }

    public static int compareDateStr(String t1, String t2) {
        int trr2;
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        if (trr1 > (trr2 = Integer.parseInt(t2.replaceAll("-", "")))) {
            return 1;
        }
        if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    public static String getMonthStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return String.format("%02d", month);
    }

    public static String getYearStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String year = String.valueOf(cal.get(1));
        return year;
    }

    public static Integer getWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Integer week = cal.get(4);
        if (cal.get(7) == 1) {
            week = week - 1;
        }
        return week;
    }

    public static String getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String year = String.valueOf(cal.get(1));
        return year;
    }

    public static List<String> getMonthBetweenDate(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (startDate.getTime() <= endDate.getTime()) {
            list.add(DateUtil.getMonth(startDate));
            cal.setTime(startDate);
            cal.add(2, 1);
            startDate = cal.getTime();
            ++i;
        }
        return list;
    }

    public static String getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(cal.getTime());
    }

    public static String getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(cal.getTime());
    }

    public static String getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(cal.getTime());
    }

    public static String getNextMonth(String month) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(month));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal.add(2, 1);
        return sdf.format(cal.getTime());
    }

    public static Integer turnZnDayOfWeek(Integer day) {
        return (day = Integer.valueOf(day + 1)) > 7 ? day - 6 : day;
    }

    public static Integer turnZnDayOfMonth(Integer day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (day > cal.getActualMaximum(5)) {
            cal.add(5, 1);
            day = cal.get(5);
            return day;
        }
        return day == 30 ? cal.getActualMaximum(5) : day.intValue();
    }

    public static String formatDateString(String str) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        Date date = new Date();
        try {
            Double par = Double.parseDouble(str);
            date = DateUtil.DoubleToDate(par);
        }
        catch (NumberFormatException e) {
            SimpleDateFormat bsdf = new SimpleDateFormat(DateUtil.getDateFormat(str));
            date = bsdf.parse(str);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }

    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date parseMonth(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if (!year) {
            if (str.contains("\u6708") || str.contains("-") || str.contains("/")) {
                if (Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            } else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            char lastChar;
            char chr = str.charAt(i);
            if (Character.isDigit(chr)) {
                if (index == 0) {
                    sb.append("y");
                }
                if (index == 1) {
                    sb.append("M");
                }
                if (index == 2) {
                    sb.append("d");
                }
                if (index == 3) {
                    sb.append("H");
                }
                if (index == 4) {
                    sb.append("m");
                }
                if (index == 5) {
                    sb.append("s");
                }
                if (index != 6) continue;
                sb.append("S");
                continue;
            }
            if (i > 0 && Character.isDigit(lastChar = str.charAt(i - 1))) {
                ++index;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    public static Date addDays(@NotNull Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date addMonths(@NotNull Date date, int amount) {
        return DateUtils.addMonths((Date)date, (int)amount);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String formatSeconds(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static Date beginOfDate(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static Date endOfDate(@NotNull Date date) {
        return new Date(DateUtil.nextDate(date).getTime() - 1L);
    }

    public static Date nextDate(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)5);
    }

    public static Date beginOfMonth(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)2);
    }

    public static Date beginOfYear(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)1);
    }

    public static void main(String[] args) {
        String date1 = "2021-9.10";
        String date2 = "2021-12";
        System.out.println(DateUtil.getDateFormat(date1));
        try {
            System.out.println(DateUtil.formatDateString(date1));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

