/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.home.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.home.consts.ProjectStatusEnum;
import com.ejianc.business.pro.home.mapper.HomePortalMapper;
import com.ejianc.business.pro.home.service.IHomePortalService;
import com.ejianc.business.pro.home.util.CommonListCallable;
import com.ejianc.business.pro.home.util.DateUtil;
import com.ejianc.business.pro.home.util.JSONUtils;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.ProductionPlanEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionPlanService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="homePortalService")
public class HomePortalServiceImpl
extends BaseServiceImpl<HomePortalMapper, BaseEntity>
implements IHomePortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IProductionPlanService planService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IProjectPoolApi projectSetApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject productReplyReport(QueryParam queryParam) {
        CommonResponse resp;
        JSONObject page = new JSONObject();
        page.put("current", (Object)"1");
        page.put("size", (Object)"10");
        page.put("records", new ArrayList());
        page.put("total", (Object)"0");
        page.put("pages", (Object)"1");
        if (!queryParam.getParams().containsKey("month")) {
            return page;
        }
        String month = String.valueOf(((Parameter)queryParam.getParams().get("month")).getValue());
        Date monthDate = DateUtil.parseDate(month + "-01");
        queryParam.getParams().remove("month");
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (!orderMap.containsKey("buildUnitName")) {
            queryParam.getOrderMap().put("buildUnitName", "asc");
        }
        if (!orderMap.containsKey("projectDate")) {
            queryParam.getOrderMap().put("projectDate", "desc");
        }
        if (queryParam.getOrderMap().containsKey("projectStatusName")) {
            queryParam.getOrderMap().put("projectStatus", queryParam.getOrderMap().get("projectStatusName"));
            queryParam.getOrderMap().remove("projectStatusName");
        }
        if (!(resp = this.projectSetApi.queryProjectIPage(queryParam)).isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        Page pageData = (Page)resp.getData();
        page.put("current", (Object)("" + pageData.getCurrent()));
        page.put("size", (Object)("" + pageData.getSize()));
        page.put("records", new ArrayList());
        page.put("total", (Object)("" + pageData.getTotal()));
        page.put("pages", (Object)("" + pageData.getPages()));
        if (CollectionUtils.isEmpty((Collection)pageData.getRecords())) {
            return page;
        }
        List projectList = pageData.getRecords();
        List projectIds = projectList.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.getParams().put("replyDate", new Parameter("ne", null));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, this.productionService);
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, this.quoteService);
        Future<JSONArray> future3 = CommonListCallable.excute(threadPool, param3, this.contractService);
        ArrayList<ProductionEntity> productionList = new ArrayList();
        List<Object> quoteList = new ArrayList();
        List<Object> contractList = new ArrayList();
        try {
            productionList = JSONUtils.json2List(future1.get().toJSONString(), ProductionEntity.class);
            quoteList = JSONUtils.json2List(future2.get().toJSONString(), QuoteEntity.class);
            contractList = JSONUtils.json2List(future3.get().toJSONString(), ContractRegisterEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        this.setProductionPlanList(productionList);
        Map<Long, List<ContractRegisterEntity>> contractMap = contractList.stream().collect(Collectors.groupingBy(x -> x.getProjectId()));
        Map<Long, List<ProductionEntity>> productionMap = productionList.stream().collect(Collectors.groupingBy(x -> x.getProjectId()));
        Map<Long, List<QuoteEntity>> quoteMap = quoteList.stream().collect(Collectors.groupingBy(x -> x.getProjectId()));
        JSONArray array = new JSONArray();
        for (ProjectPoolSetVO project : projectList) {
            Long projectId = project.getId();
            JSONObject obj = new JSONObject();
            obj.put("projectId", (Object)projectId);
            obj.put("buildUnitName", (Object)project.getBuildUnitName());
            obj.put("name", (Object)project.getName());
            obj.put("constructName", (Object)project.getConstructName());
            obj.put("projectScale", (Object)project.getMeasure());
            obj.put("projectStatus", (Object)project.getProjectStatus());
            obj.put("projectStatusName", (Object)ProjectStatusEnum.getEnumByCode(project.getProjectStatus()).getName());
            obj.put("projectDate", (Object)DateUtil.formatDate(project.getProjectDate()));
            BigDecimal contractMny = null;
            if (contractMap.containsKey(projectId)) {
                contractMny = contractMap.get(projectId).stream().map(x -> x.getBaseTaxMoney()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            }
            obj.put("contractMny", (Object)ComputeUtil.scaleTwo(contractMny));
            Date endOfLastYear = DateUtil.endOfLastYear(monthDate);
            Date beginOfMonth = DateUtil.beginOfMonth(monthDate);
            Date endOfMonth = DateUtil.endOfMonth(monthDate);
            Date beginOfYear = DateUtil.beginOfYear(monthDate);
            Date nextMonth = DateUtil.addMonths(monthDate, 1);
            BigDecimal lastYearProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), null, endOfLastYear);
            obj.put("lastYearProductMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)lastYearProductMny, (BigDecimal)new BigDecimal("10000"))));
            BigDecimal lastYearQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), null, endOfLastYear);
            obj.put("lastYearQuoteMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)lastYearQuoteMny, (BigDecimal)new BigDecimal("10000"))));
            obj.put("lastYearShouldMny", null);
            obj.put("lastYearReceiveMny", null);
            obj.put("lastYearDebtMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)obj.getBigDecimal("lastYearShouldMny"), (BigDecimal)obj.getBigDecimal("lastYearReceiveMny"))));
            BigDecimal monthProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), beginOfMonth, endOfMonth);
            obj.put("monthProductMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)monthProductMny, (BigDecimal)new BigDecimal("10000"))));
            BigDecimal monthQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), beginOfMonth, endOfMonth);
            obj.put("monthQuoteMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)monthQuoteMny, (BigDecimal)new BigDecimal("10000"))));
            obj.put("monthShouldMny", null);
            obj.put("monthReceiveMny", null);
            obj.put("monthDebtMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)obj.getBigDecimal("monthShouldMny"), (BigDecimal)obj.getBigDecimal("monthReceiveMny"))));
            BigDecimal yearProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), beginOfYear, endOfMonth);
            obj.put("yearProductMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)yearProductMny, (BigDecimal)new BigDecimal("10000"))));
            BigDecimal yearQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), beginOfYear, endOfMonth);
            obj.put("yearQuoteMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)yearQuoteMny, (BigDecimal)new BigDecimal("10000"))));
            obj.put("yearShouldMny", null);
            obj.put("yearReceiveMny", null);
            obj.put("yearDebtMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)obj.getBigDecimal("yearShouldMny"), (BigDecimal)obj.getBigDecimal("yearReceiveMny"))));
            BigDecimal sumProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), null, endOfMonth);
            obj.put("sumProductMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumProductMny, (BigDecimal)new BigDecimal("10000"))));
            BigDecimal sumQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), null, endOfMonth);
            obj.put("sumQuoteMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumQuoteMny, (BigDecimal)new BigDecimal("10000"))));
            obj.put("sumShouldMny", null);
            obj.put("sumReceiveMny", null);
            obj.put("sumDebtMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)obj.getBigDecimal("sumShouldMny"), (BigDecimal)obj.getBigDecimal("sumReceiveMny"))));
            if (productionMap.containsKey(projectId)) {
                ProductionEntity production = productionMap.get(projectId).stream().filter(x -> DateUtil.isSameMonth(x.getEndDate(), monthDate)).findAny().orElse(new ProductionEntity());
                ProductionPlanEntity plan = production.getPlanList().stream().filter(x -> DateUtil.isSameMonth(x.getMonth(), nextMonth)).findAny().orElse(new ProductionPlanEntity());
                obj.put("planProductMny", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeDiv((BigDecimal)plan.getPlanTaxMny(), (BigDecimal)new BigDecimal("10000"))));
                obj.put("planProgress", (Object)plan.getPlanProgress());
            }
            array.add((Object)obj);
        }
        page.put("records", (Object)array);
        return page;
    }

    private void setProductionPlanList(List<ProductionEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", ids));
        List planList = this.planService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)planList)) {
            return;
        }
        Map<Long, List<ProductionPlanEntity>> planMap = planList.stream().collect(Collectors.groupingBy(x -> x.getPid()));
        for (ProductionEntity entity : list) {
            if (!planMap.containsKey(entity.getId())) continue;
            entity.setPlanList(planMap.get(entity.getId()));
        }
    }

    private BigDecimal getProductionTaxMnyByDate(List<ProductionEntity> list, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List filter = list.stream().filter(x -> {
            if (null == startDate) {
                return DateUtil.compareDate(x.getEndDate(), endDate) <= 0;
            }
            if (null == endDate) {
                return DateUtil.compareDate(x.getEndDate(), startDate) >= 0;
            }
            return DateUtil.compareDate(x.getEndDate(), startDate) >= 0 && DateUtil.compareDate(x.getEndDate(), endDate) <= 0;
        }).collect(Collectors.toList());
        BigDecimal mny = filter.stream().map(x -> x.getProductionTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        return mny;
    }

    private BigDecimal getReplyTaxMnyByDate(List<QuoteEntity> list, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List filter = list.stream().filter(x -> {
            if (null == startDate) {
                return DateUtil.compareDate(x.getReplyDate(), endDate) <= 0;
            }
            if (null == endDate) {
                return DateUtil.compareDate(x.getReplyDate(), startDate) >= 0;
            }
            return DateUtil.compareDate(x.getReplyDate(), startDate) >= 0 && DateUtil.compareDate(x.getReplyDate(), endDate) <= 0;
        }).collect(Collectors.toList());
        BigDecimal mny = filter.stream().map(x -> x.getReplyTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        return mny;
    }
}

