/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ClaimDetailEntity;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IClaimDetailService;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.ParamUtil;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.business.pro.income.vo.ClaimDetailVO;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"claim"})
public class ClaimController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INCOME_NEGOTIATE_CODE = "INCOME_NEGOTIATE";
    private static final String INCOME_VISA_CODE = "INCOME_VISA";
    private static final String PROINCOME_CLAIM_CODE = "PROINCOME_CLAIM";
    private static final String QS = "QS";
    private static final String QZ = "QZ";
    private static final String SP = "SP";
    public static final Map<String, String> BillCodeMap = new HashMap<String, String>();
    public static final Map<String, String> ReplyStatusMap;
    @Autowired
    private IClaimService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IClaimRecordsService claimRecordsService;
    @Autowired
    private IClaimDetailService claimDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimVO> saveOrUpdate(@RequestBody ClaimVO saveorUpdateVO) {
        ClaimEntity entity = (ClaimEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ClaimEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_VISA_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setReplyStatus("0");
        entity.setUseFlag(0);
        entity.setUseCzFlag(0);
        entity.setRegistrationUseFlag(0);
        this.service.saveOrUpdate((Object)entity, false);
        this.claimRecordsService.updateClaimRecords(entity.getId(), entity.getReplyStatus(), saveorUpdateVO.getClaimRecordIds(), entity.getBillCode());
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimVO> updateAll(@RequestBody ClaimVO saveorUpdateVO) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        List claimRecordIds = saveorUpdateVO.getClaimRecordIds();
        if (CollectionUtils.isNotEmpty((Collection)claimRecordIds)) {
            claimRecordIds.forEach(e -> {
                LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                lambda.eq(BaseEntity::getId, e);
                lambda.set(ClaimRecordsEntity::getClaimId, (Object)saveorUpdateVO.getId());
                lambda.set(ClaimRecordsEntity::getClaimCode, (Object)claimEntity.getBillCode());
                lambda.set(ClaimRecordsEntity::getQuoteStatus, (Object)CommonConstants.SLZ);
                this.claimRecordsService.update((Wrapper)lambda);
            });
        }
        List detailList = saveorUpdateVO.getDetailList();
        for (ClaimDetailVO claimDetailVO : detailList) {
            claimDetailVO.setMid(saveorUpdateVO.getId());
        }
        List claimDetailEntities = BeanMapper.mapList((Iterable)detailList, ClaimDetailEntity.class);
        if (CollectionUtils.isNotEmpty((Collection)claimDetailEntities)) {
            this.claimDetailService.saveOrUpdateBatch(claimDetailEntities);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimVO> queryDetail(Long id) {
        ClaimEntity entity = (ClaimEntity)((Object)this.service.selectById(id));
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVO> vos) {
        this.service.removeByIds(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()), true);
        this.claimRecordsService.deleteClaimId(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        List claimVOS = BeanMapper.mapList((Iterable)page.getRecords(), ClaimVO.class);
        claimVOS.forEach(e -> {
            e.setReplyStatusName(ReplyStatusMap.get(e.getReplyStatus()));
            long days = this.getDays(new Date(), e.getSubmitDate());
            if (e.getReplyStatus().equals("0") && days >= 21L) {
                String s = ReplyStatusMap.get(e.getReplyStatus()) + "(\u5df2\u8fc7" + days + "\u5929)";
                e.setReplyStatusName(s);
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(claimVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private long getDays(Date date, Date date2) {
        LocalDate localDate1 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long diffDays = Math.abs(localDate2.toEpochDay() - localDate1.toEpochDay());
        return diffDays;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List claimVOS = BeanMapper.mapList((Iterable)list, ClaimVO.class);
        claimVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setReplyStatusName(ReplyStatusMap.get(e.getReplyStatus()));
            long days = this.getDays(new Date(), e.getSubmitDate());
            if (days >= 21L) {
                String s = ReplyStatusMap.get(e.getReplyStatus()) + "(\u5df2\u8fc7" + days + "\u5929)";
                e.setReplyStatusName(ReplyStatusMap.get(s));
            }
            if (e.getApprovalFlag() != null && e.getApprovalFlag() == 0) {
                e.setApprovalFlagName("\u5426");
            }
            if (e.getApprovalFlag() != null && e.getApprovalFlag() == 1) {
                e.setApprovalFlagName("\u662f");
            }
            if (QS.equals(e.getDjType())) {
                e.setBillTypeName("\u53d8\u66f4\u6d3d\u5546\u5355");
            } else if (QZ.equals(e.getDjType())) {
                e.setBillTypeName("\u7b7e\u8bc1");
            } else if (SP.equals(e.getDjType())) {
                e.setBillTypeName("\u7d22\u8d54");
            } else {
                e.setBillTypeName(null);
            }
        });
        beans.put("records", claimVOS);
        ExcelExport.getInstance().export("claim-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/updateReplyDate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateReplyDate(@RequestBody ClaimVO claim) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.service.selectById(claim.getId()));
        if (claimEntity != null) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)claim.getId());
            wrapper.set(ClaimEntity::getReplyDate, (Object)claim.getReplyDate());
            wrapper.set(ClaimEntity::getReplyStatus, (Object)claim.getReplyStatus());
            wrapper.set(ClaimEntity::getReplyMny, (Object)claim.getReplyMny());
            wrapper.set(ClaimEntity::getReplyTaxMny, (Object)claim.getReplyTaxMny());
            wrapper.set(ClaimEntity::getReplyTax, (Object)claim.getReplyTax());
            wrapper.set(ClaimEntity::getReplyDuration, (Object)claim.getReplyDuration());
            wrapper.set(ClaimEntity::getReplyDescription, (Object)claim.getReplyDescription());
            this.service.update((Wrapper)wrapper);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(ClaimRecordsEntity::getClaimId, (Object)claim.getId());
            updateWrapper.set(ClaimRecordsEntity::getReplyStatus, (Object)claim.getReplyStatus());
            this.claimRecordsService.update((Wrapper)updateWrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
    }

    @GetMapping(value={"queryBudgetList"})
    @ResponseBody
    public CommonResponse<List<BudgetVO>> queryBudgetList(@RequestParam(value="id") Long id) {
        List<BudgetVO> budgetVOS = this.budgetService.selectByUseId(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", budgetVOS);
    }

    @GetMapping(value={"queryClaimRecordsList"})
    @ResponseBody
    public CommonResponse<List<ClaimRecordsVO>> queryClaimRecordsList(@RequestParam(value="id") Long id) {
        List<ClaimRecordsVO> claimRecordsVOS = this.claimRecordsService.selectByClaimId(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", claimRecordsVOS);
    }

    @GetMapping(value={"queryRecordByContractId"})
    @ResponseBody
    public CommonResponse<ClaimRecordVO> queryRecordByContractId(@RequestParam(value="id") Long contractId) {
        ClaimRecordVO vo = this.service.queryRecordByContractId(contractId);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"connectAppendix"})
    @ResponseBody
    public CommonResponse<String> connectAppendix(@RequestBody AttachmentVO vo) {
        ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
        vo.setId(null);
        vo.setSourceType("102345678");
        vo.setRowState("add");
        list.add(vo);
        this.attachmentApi.insertBatch(list);
        return CommonResponse.success();
    }

    @GetMapping(value={"relevanceBudget"})
    @ResponseBody
    public CommonResponse relevanceBudget(@RequestParam(value="id") Long id, @RequestParam(value="budgetIds") List<Long> budgetIds, @RequestParam(value="billType") String billType) {
        this.budgetService.relevanceBudget(id, budgetIds, billType);
        return CommonResponse.success((String)"\u5173\u8054\u6210\u529f");
    }

    @GetMapping(value={"deleteRelevanceBudget"})
    @ResponseBody
    public CommonResponse deleteRelevanceBudget(@RequestParam(value="budgetIds") List<Long> budgetIds) {
        this.budgetService.deleteRelevanceBudget(budgetIds);
        return CommonResponse.success((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f");
    }

    @PostMapping(value={"updateMny"})
    @ResponseBody
    public CommonResponse updateMny(@RequestBody ClaimVO claimVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)claimVO.getId());
        wrapper.set(ClaimEntity::getClaimMny, (Object)claimVO.getClaimMny());
        wrapper.set(ClaimEntity::getClaimTaxMny, (Object)claimVO.getClaimTaxMny());
        wrapper.set(ClaimEntity::getClaimTax, (Object)claimVO.getClaimTax());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u91d1\u989d\u6210\u529f");
    }

    @GetMapping(value={"/syncUpdateContract"})
    @ResponseBody
    public CommonResponse<Boolean> syncUpdateContract(@RequestParam(value="id") Long id) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.service.selectById(id));
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntity.getContractId()));
        if (null != contractRegisterEntity) {
            if (contractRegisterEntity.getBillPushFlag() == null || contractRegisterEntity.getBillPushFlag().equals(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus())) {
                CommonResponse.error((String)"\u8bf7\u5148\u5c06\u5408\u540c\u63a8\u9001\u81f3\u5408\u540c\u6c60\uff01");
            }
        } else {
            CommonResponse.error((String)"\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.updateContract(claimEntity, true));
    }

    @RequestMapping(value={"/refClaimData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> refClaimData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("claimTitle");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getOrderMap().put("createTime", "desc");
        boolean productType = false;
        Integer registrationUseFlag = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            }
            if (null != conditionMap.get("productType")) {
                productType = Boolean.valueOf(conditionMap.get("productType").toString());
            }
            if (null != conditionMap.get("registrationUseFlag")) {
                registrationUseFlag = Integer.valueOf(conditionMap.get("registrationUseFlag").toString());
            }
        }
        if (null == registrationUseFlag) {
            ComplexParam useFlag = ParamUtil.getOrParam(productType ? "useCzFlag" : "useFlag", new Parameter("eq", null), new Parameter("ne", (Object)CommonConstants.SLZ));
            queryParam.getComplexParams().add(useFlag);
        }
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ClaimVO.class);
        for (ClaimVO vo : list) {
            if (QS.equals(vo.getDjType())) {
                vo.setBillTypeName("\u53d8\u66f4\u6d3d\u5546\u5355");
            } else if (QZ.equals(vo.getDjType())) {
                vo.setBillTypeName("\u7b7e\u8bc1");
            } else if (SP.equals(vo.getDjType())) {
                vo.setBillTypeName("\u7d22\u8d54");
            } else {
                vo.setBillTypeName(null);
            }
            if ("0".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u672a\u6279\u590d");
                continue;
            }
            if ("1".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u5df2\u6279\u590d");
                continue;
            }
            if ("2".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u672a\u901a\u8fc7");
                continue;
            }
            vo.setReplyStatusName(null);
        }
        result.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    static {
        BillCodeMap.put(QS, INCOME_NEGOTIATE_CODE);
        BillCodeMap.put(QZ, INCOME_VISA_CODE);
        BillCodeMap.put(SP, PROINCOME_CLAIM_CODE);
        ReplyStatusMap = new HashMap<String, String>();
        ReplyStatusMap.put("0", "\u672a\u6279\u590d");
        ReplyStatusMap.put("1", "\u5df2\u6279\u590d");
        ReplyStatusMap.put("2", "\u672a\u901a\u8fc7");
    }
}

