package com.ejianc.business.pro.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.home.service.IHomePortalService;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 门户首页 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@RestController
@RequestMapping("/homePortal")
public class HomePortalController {

    @Autowired
    private IHomePortalService service;

    @Autowired
    private IClaimService claimService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IFinalizedService finalizedService;

    @Autowired
    private IContractRegisterService contractRegisterService;

    @Autowired
    private IProductionService productionService;


    /**
     * 产值甲方批复回款台账
     * @param param
     * month-月份，projectStatus-项目状态：项目状态：1、在建 2、停缓建 3、竣工验收 4、已完工 5、其他，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/productReplyReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReport(@RequestBody QueryParam param) {
        JSONObject result = service.productReplyReport(param);
        return CommonResponse.success(result);
    }

    /**
     * 产值甲方批复回款台账导出
     * @param param
     * month-月份，projectStatus-项目状态：项目状态：1、在建 2、停缓建 3、竣工验收 4、已完工 5、其他，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/productReplyReportExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject result = service.productReplyReport(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result.getJSONArray("records"));
        ExcelExport.getInstance().export("production-reply-export.xlsx", beans, response);
        return CommonResponse.success(result);
    }

    @PostMapping(value = "getSecOprSituation")
    public CommonResponse<JSONObject> getSecOprSituation(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        String year = "thisYear";
        if(params.containsKey("year")) {
            year = params.getString("year");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", Parameter.getInInstance(new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        }));
        if("thisYear".equals(year)) {
            queryParam.getParams().put("happenDate", new Parameter(QueryParam.SQL, " DATE_FORMAT(happen_date, '%Y') = '"+ DateUtil.getCurrentYear() +"'"));
        }
        queryParam.getParams().put("replyStatus", Parameter.getEqInstance(CommonConstants.YPF));

        List<ClaimEntity> dbList = claimService.queryList(queryParam);
        BigDecimal totalApplyMny = BigDecimal.ZERO;
        BigDecimal totalApprMny = BigDecimal.ZERO;
        for(ClaimEntity c : dbList) {
            totalApplyMny = ComputeUtil.safeAdd(totalApplyMny, c.getClaimTaxMny());
            totalApprMny = ComputeUtil.safeAdd(totalApprMny, c.getReplyTaxMny());
        }

        totalApplyMny = ComputeUtil.safeDiv(totalApplyMny, new BigDecimal("10000"));
        totalApprMny = ComputeUtil.safeDiv(totalApprMny, new BigDecimal("10000"));
        resp.put("totalApplyMny", totalApplyMny);
        resp.put("totalApprMny", totalApprMny);

        return CommonResponse.success("查询成功！", resp);
    }

    @PostMapping(value = "/getFinalAccountsFinalized")
    public CommonResponse<JSONObject> getFinalAccountsFinalized(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        String period = "1";
        if(params.containsKey("period")) {
            period = params.getString("period");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", Parameter.getInInstance(new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        }));
        queryParam.getParams().put("finalStage", Parameter.getInInstance(new String[]{
                CommonConstants.一审中, CommonConstants.终审中
        }));

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String todayStr = sdf.format(new Date());
        if("1".equals(period)) {
            //一年内
            queryParam.getParams().put("finalInstanceDate", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"+todayStr+")' >=0 AND DATEDIFF(DAY, report_date, '"+todayStr+")' <= 365"));
        } else if("2".equals(period)) {
            //1~3年内
            queryParam.getParams().put("finalInstanceDate", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"+todayStr+"') >365 AND DATEDIFF(DAY, report_date, '"+todayStr+")' <= 1095"));
        } else {
            //3年以上
            queryParam.getParams().put("finalInstanceDate", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"+todayStr+"') > 1095"));
        }

        List<FinalizedEntity> dbList = finalizedService.queryList(queryParam);
        resp.put("nums", dbList.size());


        return CommonResponse.success(resp);
    }

    @PostMapping(value = "/getOperationInfo")
    public CommonResponse<JSONObject> getOperationInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }

        List<Long> orgIds = iOrgApi.findChildrenByParentIdWithoutProjectDept(
                orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryParam conParam = new QueryParam();
        conParam.getParams().put("parentOrgId", Parameter.getInInstance(orgIds));
        conParam.getParams().put("billState", Parameter.getInInstance(new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        }));
        conParam.getParams().put("signDate", new Parameter(QueryParam.SQL, " DATE_FORMAT(sign_date, '%Y') = '"+ DateUtil.getCurrentYear() +"'"));
        List<ContractRegisterEntity> conList = contractRegisterService.queryList(conParam);
        BigDecimal conTotalTaxMny = conList.stream().map(ContractRegisterEntity::getTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);

        conParam.getParams().remove("signDate");
        conParam.getParams().put("startDate", new Parameter(QueryParam.SQL, " DATE_FORMAT(start_date, '%Y') = '"+ DateUtil.getCurrentYear() +"'"));
        List<ProductionEntity> pList = productionService.queryList(conParam);
        BigDecimal pTotalTaxMny = pList.stream().map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);

        resp.put("conTotalTaxMny", ComputeUtil.safeDiv(conTotalTaxMny, new BigDecimal("10000")));
        resp.put("pTotalTaxMny", ComputeUtil.safeDiv(pTotalTaxMny, new BigDecimal("10000")));

        return CommonResponse.success("查询成功！", resp);
    }
}

