package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("claimRecords") 
public class ClaimRecordsBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IClaimRecordsService service;



	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		LambdaUpdateWrapper<ClaimRecordsEntity> updateWrapper = new LambdaUpdateWrapper();
		updateWrapper.eq(ClaimRecordsEntity::getId, billId);
//		updateWrapper.set(ClaimRecordsEntity::getReplyStatus, CommonConstants.WU);
		updateWrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.WYY);
		updateWrapper.set(ClaimRecordsEntity::getHandleState, 1);
		updateWrapper.set(ClaimRecordsEntity::getFinishState, 0);
		service.update(updateWrapper);



		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		ClaimRecordsEntity claimRecordsEntity = service.selectById(billId);
		if (!CommonConstants.WYY.equals(claimRecordsEntity.getQuoteStatus())){
			return CommonResponse.error("此单据已被其它单据引用，无法撤回！");
		}

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		LambdaUpdateWrapper<ClaimRecordsEntity> updateWrapper = new LambdaUpdateWrapper();
		updateWrapper.eq(ClaimRecordsEntity::getId, billId);
//		updateWrapper.set(ClaimRecordsEntity::getReplyStatus, null);
		updateWrapper.set(ClaimRecordsEntity::getQuoteStatus, null);
		updateWrapper.set(ClaimRecordsEntity::getHandleState, null);
		service.update(updateWrapper);

		return CommonResponse.success();
	}

}
