package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.vo.ClaimDetailVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.ClaimDetailMapper;
import com.ejianc.business.pro.income.bean.ClaimDetailEntity;
import com.ejianc.business.pro.income.service.IClaimDetailService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 签证索赔单-子表
 * 
 * @author generator
 * 
 */
@Service("claimDetailService")
public class ClaimDetailServiceImpl extends BaseServiceImpl<ClaimDetailMapper, ClaimDetailEntity> implements IClaimDetailService{
    @Autowired
    private IClaimRecordsService claimRecordsService;
    @Override
    public void delete(List<ClaimDetailVO> vos) {
        List<Long> ids = vos.stream().map(ClaimDetailVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ClaimDetailEntity> lambda = Wrappers.<ClaimDetailEntity>lambdaQuery();
        lambda.in(ClaimDetailEntity::getId,ids);
        List<ClaimDetailEntity> claimDetailEntityList = super.list(lambda);
        List<Long> claimRecordId = claimDetailEntityList.stream().map(ClaimDetailEntity::getClaimRecordId).collect(Collectors.toList());

        super.removeByIds(vos.stream().map(ClaimDetailVO::getId).collect(Collectors.toList()),true);

        LambdaQueryWrapper<ClaimRecordsEntity> lambdaRecord = Wrappers.<ClaimRecordsEntity>lambdaQuery();
        lambdaRecord.in(ClaimRecordsEntity::getId,claimRecordId);
        List<ClaimRecordsEntity> claimRecordsEntities = claimRecordsService.list(lambdaRecord);
        for(ClaimRecordsEntity claimRecordsEntity : claimRecordsEntities){
            claimRecordsEntity.setClaimId(null);
            claimRecordsEntity.setClaimCode(null);
            claimRecordsEntity.setReplyStatus(null);
            claimRecordsEntity.setQuoteStatus(CommonConstants.WYY);
        }
        claimRecordsService.updateBatchById(claimRecordsEntities);
    }
}
